// case - file manager for N900
// Copyright (C) 2010 Lukas Hrazky <lukkash@email.cz>
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.


#include "addressbar.h"
#include "fileoperator.h"

AddressBar::AddressBar(QWidget *parent) : QLineEdit(parent) {
    setMaximumHeight(60);
    setContentsMargins(-4, -4, -4, -4);

    connect(this, SIGNAL(returnPressed()), this, SLOT(returnPressed()));
}


void AddressBar::setText(const QString &text) {
    QLineEdit::setText(FileOperator::shortenPath(text));
}


void AddressBar::mousePressEvent(QMouseEvent *event) {
    emit mousePressed();
    QLineEdit::mousePressEvent(event);
}


void AddressBar::returnPressed() {
    emit pathEntered(text());
}
