/* random-data.c
 *
 * Generate random data to simulate GPS and OBD samples.
 *
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of carmand.
 *  
 *  carmand is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  carmand is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#include "../src/trip.h"

int main(int argc, char **argv)
{
	struct trip_header header;
	struct trip_data data;
	FILE *output;
	int num_data;
	int i;
	int rtv;


	if (argc != 3) {
		printf("Ops, Use: %s <file-path> <num data>\n", argv[0]);
		return EXIT_FAILURE;
	}

	output = fopen(argv[1], "wb");
	if (output == NULL) {
		char error_msg[255];
		sprintf(error_msg, "Error opening file '%s'", argv[1]);
		perror(error_msg);
		return EXIT_FAILURE;
	}

	header.precision = 5000;
	header.start_time = time(NULL);
	rtv = fwrite(&header, sizeof(header), 1, output);
	if (rtv != 1) {
		char error_msg[255];
		sprintf(error_msg, "Error writing to file '%s'", argv[1]);
		perror(error_msg);
		return EXIT_FAILURE;
	}

	num_data = atoi(argv[2]);
	srand( time(NULL) );
	for (i = 0; i < num_data; i++) {
		data.time = (i * header.precision) / 1000;
		data.mask = 0;
		data.lat = rand() % 90;
		data.lon = rand() % 180;
		data.speed = rand() % 300;
		data.rpm = rand() % 1300;

		rtv = fwrite(&data, sizeof(data), 1, output);
		if (rtv != 1) {
			char error_msg[255];
			sprintf(error_msg, "Error writing to file '%s'", argv[1]);
			perror(error_msg);
			return EXIT_FAILURE;
		}
	}

	fclose(output);

	return EXIT_SUCCESS;
}
