
#include <stdio.h>
#include <stdlib.h>
#include "carmand-trip.h"

int main (int argc, char **argv)
{
	FILE *fh = NULL;
	char *file = NULL;
	int len = 0;
	struct trip_header header;
	struct trip_data data;

	file = *++argv;

	fh = fopen(file, "r");

	printf("Trip file: %s\n", file);
	len = fread(&header, 1, sizeof(struct trip_header), fh);

	if (len < sizeof(struct trip_header) ||
		strncmp(header.file_header, "CMAN", 4)) {
		printf("Problems opening the trip file\n");
	}


	printf("Carmand version: %d\n", header.app_version);
	printf("Trip version: %d\n", header.file_version);
	printf("Tips start time: %lu\n", header.start_time);
	printf("Trip precision: %lu\n", header.precision);


	printf("Size do struct: %d\n", sizeof(struct trip_data));

	while (fread(&data, 1, sizeof(struct trip_data), fh) > 0) {
		if (!data.flag & TRIP_LAT_LON)
			continue;

		printf("lat: %f lon: %f alt: %f dist: %d rpm: %d speed: %f\n",
				data.lat, data.lon, data.alt, data.distance,
				data.rpm, data.speed);
	}

	fclose(fh);

	return 0;
}
