#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{SpeedAlertDlgView}.
"""

from main.basedlgview import BaseDlgView

class SpeedAlertDlgView(BaseDlgView):
    """
    L{SpeedAlertDlgController}'s view.

    @type   value: number
    @param  value: Speed value.
    @type   metric: boolean
    @param  metric: C{True} if speed unit is metric,
        C{False} if speed unit is imperial.
    """
    def __init__(self, value, metric=True):
        BaseDlgView.__init__(self, "speedalert", 25)
        if metric:
            self.unit = " Km/h"
        else:
            self.unit = " mph"
        self.value_set(value)

    def value_set(self, value):
        """
        Sets speed value in 'max_display' part.

        @type   value: number
        @param  value: Speed value.
        """
        self.part_text_set("max_display", str(value)+self.unit)
