#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{NewBuddyController}.
"""

from main.messagedlgctrl import MessageDlgController
from maps.managenewbuddyview import ManageNewBuddyDlgView
from models.infosharingmodel import InfoSharingModel

class NewBuddyController(object):
    """
    New Buddy dialog controller.

    @type   parent: L{ListView}
    @param  parent: Parent window.
    """
    def __init__(self, parent):
        self.is_service = InfoSharingModel().service
        self.view = ManageNewBuddyDlgView(self.__save_buddy_cb)

    def __get_account_active(self):
        """
        Returns the active account.

        @rtype: tuple
        @return: C{(name, protocol_id)}.
        """
        accounts = self.is_service.get_accounts_active()
        if not accounts:
            return None
        else:
            return accounts[0]

    def __buddy_exists(self, name):
        """
        Checks if a buddy exists in the buddy list.

        @type   name: string
        @param  name: Buddy name.

        @rtype: boolean
        @return: C{True} it the buddy exists, C{False} otherwise.
        """
        buddies = self.is_service.get_buddies_online()
        for buddy in buddies:
            if name == buddy[0]:
                return True
        return False

    def __save_buddy_cb(self):
        """
        Callback to be called when adding a new buddy
        to the buddy list.
        """
        email = self.view.name_entry.text.strip()
        account = self.__get_account_active()
        if not account:
            msg = MessageDlgController()
            msg.show_message("No accounts active", title="NEW BUDDY")
            obj.hide(True)
            return
        elif  email == "":
            msg = MessageDlgController(self.view.name_entry_focus)
            msg.show_message("E-mail cannot be empty", title="NEW BUDDY")
            return
        elif self.__buddy_exists(email):
            msg = MessageDlgController(self.view.name_entry_focus)
            msg.show_message("Buddy already exists", title="NEW BUDDY")
            return
        elif email == account[0].split("/")[0]:
            msg = MessageDlgController(self.view.name_entry_focus)
            msg.show_message("You can't add yourself as a friend", \
                title="NEW BUDDY")
            return
        alias = self.view.alias_entry.text.strip()
        if alias == "":
            self.is_service.add_buddy(self.view.name_entry.text,
                    None)
        else:
            self.is_service.add_buddy(self.view.name_entry.text,
                    alias)
        self.view.hide(True)

    def show(self):
        """
        Displays the L{ManageNewBuddyDlgView} object.
        """
        self.view.show()
