#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{EditBuddyController}.
"""

from main.messagedlgctrl import MessageDlgController
from main.listctrl import ListView
from maps.commonbuddyctrl import CommonBuddyController
from models.infosharingmodel import InfoSharingModel

class EditBuddyController(object):
    """
    Controls to manage editing buddy options.

    @ivar _parent: L{ListView}
    @ivar is_service: L{ISService}
    @ivar view: L{ListView}
    """
    def __init__(self, parent):
        self._parent = parent
        self.is_service = InfoSharingModel().service
        self.view = ListView("list-normal", "list-item-normal", \
            "EDIT BUDDY")

    def load_list(self):
        """
        Loads from the buddy list all buddies online. If no buddies are online, a message is shown to user.
        """
        def buddy_selected_cb(obj, item, param):
            edit = CommonBuddyController(obj, param)
            edit.show()

        account = self.is_service.get_accounts_active()
        if not account:
            self.view.hide(True)
            msg = MessageDlgController()
            msg.show_message("No account currently active", title="EDIT BUDDY")
            return False

        # FIX : User can modify a buddy info even if
        #       the buddy is not connected
        buddies = self.is_service.get_buddies_online()
        if not buddies:
            self.view.hide(True)
            msg = MessageDlgController()
            msg.show_message("No buddies online", title="EDIT BUDDY")
            return False

        for buddy in buddies:
            if buddy[1]:
                self.view.add_item(buddy[1], buddy_selected_cb, param=buddy)
            else:
                self.view.add_item(buddy[0], buddy_selected_cb, param=buddy)
        return True

    def show(self):
        """
        Displays the "Edit buddy" screen.
        """
        self.view.show()
