#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""
Implements L{how_long}.

@var __DEBUG__: C{True} if debug is enabled, C{False} otherwise.
"""

from time import time

__DEBUG__ = True

def how_long(cls=None):
    """
    Basic decorator to calculate time from functions.

    @type   cls: object
    @param  cls: Not used.
    @deprecated: This method is for debugging purposes only.
    """
    def dec(func):
        def fn(self, *args, **kw):
            if __DEBUG__:
                t = time()
            res = func(self, *args, **kw)
            if __DEBUG__:
                print("%.20f;%s;%s;%s" % (time() - t, \
                    func.func_code.co_filename, \
                    func.func_code.co_firstlineno, \
                    func.__name__))
            return res
        return fn
    return dec
