#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#TODO: Fix track loading feature.
"""
import os, threading, fcntl, ecore
from rtree import Rtree

from common.carlog import DEBUG
from common.xmlparser import get_xml_parser
from models.mapmodel import MapModel
from maps.loadingctrl import LoadingController


class LoadTrackController(threading.Thread):
    def __init__(self, parent):
        threading.Thread.__init__(self)
        self.models = []
        self.running = True
        self._parent = parent
        self.in_fd, self.out_fd = os.pipe()
        arg = fcntl.fcntl(self.out_fd, fcntl.F_GETFL)
        fcntl.fcntl(self.out_fd, fcntl.F_SETFL, arg | os.O_NONBLOCK)
        self.fdh = ecore.FdHandler(self.in_fd, ecore.ECORE_FD_READ,
            self.__load_complete)
        self.fdh.active_set(ecore.ECORE_FD_READ)

    def __del__(self):
        DEBUG("deleting %s" % self)
        os.close(self.in_fd)
        os.close(self.out_fd)

    def __load_complete(self, *params):
        self.join()
        self.fdh.delete()
        self.fdh = None
        self.loading.hide()
        self.loading = None
        self._parent.hide(True)
        self._parent._parent.hide(True)
        self._parent._parent._parent.set_track_aux(self.models, self.track)

    def run(self):
        repo = MapModel().get_repository()
        track = get_xml_parser().parse(self.track)

        namespace = ""
        root_tag = track.getroot().tag
        if root_tag[0] == "{":
            namespace = root_tag.split("}")[0] + "}"

        trk = track.find("%strk" % namespace)
        if trk:
            for trkseg in trk.findall("%strkseg" % namespace):
                current = Rtree()
                self.models.append(current)
                for trkpt in trkseg.findall("%strkpt" % namespace):
                    point = repo.latlon_to_xy(float(trkpt.attrib["lat"]),
                        float(trkpt.attrib["lon"]))
                    current.add(point)
                    if not self.running:
                        return

        os.write(self.out_fd, " ")

    def __load_canceled(self):
        self.running = False
        self.join()
        self.fdh.delete()
        self.fdh = None
        self.loading = None

    def load(self, track):
        self.track = track
        self.loading = LoadingController(self.__load_canceled)
        self.loading.show()
        self.start()
"""
