#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{CommonBuddyController}.
"""

from maps.managebuddydlgview import ManageBuddyDlgView
from models.infosharingmodel import InfoSharingModel
from models.buddymodel import BuddyModel

class CommonBuddyController(object):
    """
    Common class for storing buddy info(alias).

    @type   parent: L{ListView}
    @param  parent: Parent window.
    @type   buddy: tuple
    @param  buddy: Buddy C{(name, alias)}.
    """
    def __init__(self, parent, buddy):
        self._parent = parent
        self.is_service = InfoSharingModel().service
        self.buddy_model = BuddyModel()
        self.view = ManageBuddyDlgView("EDIT BUDDY", self.__save_info_cb, \
                self.__cancel_cb, "manageeditbuddydlg1")
        if buddy[1]:
            self.view.alias_entry.text = buddy[1]

        self.__buddy = buddy

    def __save_info_cb(self, p):
        """
        Callback to be called when storing the buddy info(alias).

        @type   p: L{ManageBuddyDlgView}
        @param  p: Not used.
        """
        alias = self.view.alias_entry.text.strip()
        self.is_service.set_buddy_alias(self.__buddy[0], alias)
        self.view.hide()
        if self._parent:
            self._parent.hide(True)

    def __cancel_cb(self, *p):
        """
        Cancel callback for the L{ManageBuddyDlgView} object.

        @type   p: object
        @param  p: Not used.
        """
        self.view.hide()

    def show(self):
        """
        Displays the L{ManageBuddyDlgView} object.
        """
        self.view.show()

