#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{BaseDlgView}.
"""

import edje

from common.carlog import DEBUG
from common.carmanconfig import CarmanConfig
from main.mainview import MainView

class BaseDlgView(edje.Edje):
    """
    Handles base dialog visualization.

    @type   group: string
    @param  group: Edje group name.
    @type   layer: number
    @param  layer: Layer priority.
    """
    def __init__(self, group, layer=15):
        canvas = MainView().get_evas_canvas()
        theme = CarmanConfig().get_current_theme()
        edje.Edje.__init__(self, canvas, file=theme, group=group)
        self.layer_set(layer)
        self.signal_callback_add("hide", "", self.__destroy)

    def hide(self, hide_now=False):
        """
        Hides the C{edje.Edje} object.

        @type   hide_now: boolean
        @param  hide_now: C{True} for hiding the C{edje.Edje} object
        immediately, C{False} for hiding with animation.
        """
        if hide_now:
            self.signal_emit("hide", "")
        else:
            self.signal_emit("hide-anime", "")

    def __destroy(self, *params):
        """
        Called when 'hide' signal is emitted. Used to destroy
        C{edje.Edje} object.

        @type   params: tuple
        @param  params: Not used.
        """
        self.delete()
