#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    if (QSettings().contains("main/number"))
        ui->numberEdit->setText(QSettings().value("main/number").toString());
    ui->heightBox->setValue(QSettings().value("main/height").toInt());
    ui->widthBox->setValue(QSettings().value("main/width").toInt());
    QPushButton *aboutButton = new QPushButton(tr("About"), this);
    connect(aboutButton, SIGNAL(clicked()), this, SLOT(showAbout()));
    connect(this, SIGNAL(rejected()), this, SLOT(close()));
    ui->buttonBox->addButton(aboutButton, QDialogButtonBox::NoRole);
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::accept()
{
    if (ui->numberEdit->text().isEmpty() || ui->heightBox->text().isEmpty() || ui->widthBox->text().isEmpty()) {
        QMaemo5InformationBox::information(this, tr("Fields cannot be empty!"));
        return;
    }
    QSettings().setValue("main/number", ui->numberEdit->text());
    QSettings().setValue("main/width", ui->widthBox->value());
    QSettings().setValue("main/height", ui->heightBox->value());
    emit settingsChanged();
    this->close();
}

void SettingsDialog::showAbout()
{
    QDialog *aboutDialog = new QDialog(0);
    aboutDialog->setAttribute(Qt::WA_DeleteOnClose);
    aboutDialog->setWindowTitle(tr("About") + " " + "CardioAlert");
    QLabel *aboutText = new QLabel(aboutDialog);
    QString about;
    about.append("CardioAlert\nA single button application to do quick emergency calls from the homescreen.");
    about.append("\n\n");
    about.append(QString::fromUtf8("© 2011 Mohammad Abu-Garbeyyeh\nLicensed under GPLv3"));
    aboutText->setText(about);
    aboutText->setWordWrap(true);
    QScrollArea *aboutScroll = new QScrollArea(aboutDialog);
    QVBoxLayout *scrollLayout = new QVBoxLayout(aboutScroll);
    scrollLayout->addWidget(aboutText);
    QVBoxLayout *layout = new QVBoxLayout(aboutDialog);
    layout->addWidget(aboutScroll);
    aboutDialog->setLayout(layout);
    aboutDialog->show();
    this->close();
}
