#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_TranslucentBackground);
    if (!QSettings().contains("main/width"))
        QSettings().setValue("main/width", 600);
    if (!QSettings().contains("main/height"))
        QSettings().setValue("main/height", 400);

    connect(ui->callButton, SIGNAL(clicked()), this, SLOT(onCallButtonClicked()));
    this->reloadSettings();
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::onCallButtonClicked()
{
    if (!QSettings().contains("main/number")) {
        QMaemo5InformationBox::information(0, tr("You have to set a number in settings!"));
        return;
    }

    QString number = QSettings().value("main/number").toString();
    QMaemo5InformationBox::information(0, QString("Dialing %1").arg(number));

    // Thanks to K9Call
    QDBusMessage msg = QDBusMessage::createMethodCall(
        "com.nokia.csd.Call", // --dest
        "/com/nokia/csd/call", // destination object path
        "com.nokia.csd.Call", // message name (w/o method)
        "CreateWith" // method
    );
    msg << number;
    msg << 0;
    msg = QDBusConnection::systemBus().call(msg);

    if (msg.type() == QDBusMessage::ErrorMessage) {
        QErrorMessage* err = new QErrorMessage();
        err->showMessage(msg.errorMessage());
    }
}

void MainWindow::showSettings()
{
    SettingsDialog *dialog = new SettingsDialog(0);
    connect(dialog, SIGNAL(settingsChanged()), this, SLOT(reloadSettings()));
    dialog->show();
}

void MainWindow::reloadSettings()
{
    this->setGeometry(this->x(), this->y(),
                      QSettings().value("main/width").toInt(),
                      QSettings().value("main/height").toInt());
}
