# vim: enc=utf8 spell spelllang=ru
#

				МЕТОД

CCD проводится для каждой пары точка-отрезок, точка 
лежит на отрезке когда выполняется такое условие,

    | P - A |
det |       | == 0						(1)
    | B - A |

где AB это отрезок, а P точка. Надо сказать, что это условие принадлежности
точки всей прямой а не только отрезка, из-за чего нужно ещё одно условие,

N = A - B

S1 = (A - P) dot N
S2 = (B - P) dot N

S1 и S2 должны иметь разные знаки, т.е. S1*S2 < 0 .		(2)

Траектории заданы начальными и конечными положениями, настоящее состояние, и
состояние предыдущего шага (используется так же для интегрирования Верлета).
ABv(t) и Pv(t) выражаем вот так,

Av = A' + (A - A') * t
Bv = B' + (B - B') * t
Av = A' + (A - A') * t

Подставляем это в первое равенство, получаем квадратное уравнение, смотрим
среди его корней числа от 0 до 1, минимальное из них соответствует первому
пересечению точки и отрезка. Коэффициенты его здесь писать не буду, слишком
длинно получится. Второе условие применяем к отрезку в найденный ранее
момент времени t1 первого пересечения.

Если все условия пройдены, переходим к выталкиванию точки из отрезка и
наоборот.

Определяем расстояние от точки до прямой содержащей отрезок,

N = !(B - A)		// "!" - это операция взятия ортогонального вектора
N = N / length(N)
D = A dot N

DIST = P dot N - D
DIST = DIST * 0.5 + offset

Расталкиваем по направлению нормали, до полного выхода + еще немного

P = P - N * DIST
A = A + N * DIST
B = B + N * DIST

В программе учитывается ещё и трение, но здесь это будет лишним.

Проблемы у этого метода похоже возникают на границах отрезков, точки иногда
проскакивают через них. Это решаемо, введением дополнительного постоянного
смещения по нормали. Есть ещё проблемы с тем, что выталкивание может породить
новую коллизию, это решается грубой силой, делаем выталкивания ещё и ещё,
пока не вытолкнем все объекты.

				ОПИСАНИЕ

Клон Numpty Physics, и как оказалось Crayon Physics. Цель игры соединить
красный объект с зеленым, с помощью рисования других объектов. Объекты
подчиняются законам механики, достигнуть цели можно используя гравитацию.
Доступны твердые объекты, веревки и сгибаемые объекты.

				УПРАВЛЕНИЕ

Указателем рисуем произвольные фигуры, зажав первую кнопку. Второй кнопкой
можно ловить вершины фигур, и тащить их, только в режиме редактирования.
В режиме игры вторая кнопка меняет тип рисуемого объекта. На клавиатуре,

Основное,

	Q	- Выход
	D/ESC	- Удаление последнего добавленного объекта
	T	- Остановка времени
	P	- Режим редактирования
	R	- Перезагрузка рисунка
	N	- Следующий рисунок
	M	- Предыдущий рисунок
	K	- Сохранение рисунка
	E	- Стереть все
	H	- Объект не связывается с другими

Типы объектов,

	A	- Регулярный объект (твердый)
	С	- Неподвижные объекты
	S	- Мягкие объекты (веревки)
	B	- Сгибаемые объекты
	X	- Фоновый рисунок (цвет выбирается на 1/2/3)

Флаги объектов,

	4/5	- Игрок и цель
	L	- Петля (только для веревок)
	G	- Объект заднего плана

Какого типа объект добавится можно узнать нажав любую клавишу и посмотрев
что будет напечатано в stdout.

				ИЗМЕНЕНИЯ

* 11 Oct 2009

	Первая версия, не очень стабильна


* 23 Oct 2009

	Добавлена отрисовка через OpenGL
	Добавлен фоновый рисунок
	Физика теперь более стабильна
	Добавлено перетаскивание объектов
	Изменено управление


* 25 Oct 2009

	Добавлен режим игры и редактирования
	Добавлено сохранение и загрузка рисунков
	Более стабильная физика
	Разрывание веревок, при сильном растяжении
	Добавлено рисование петли
	Удаление захваченного объекта
	Добавлен игрок (красный) и цель (зеленая)
	Добавлено стирание всего
	Добавлено несколько рисунков


* 26 Oct 2009

	Устранен баг: Ложные соединения объектов
	Устранен баг: Появление NaN
	Устранен баг: Ошибки в загрузке рисунков
	Устранен баг: При добавлении объекта
	Отключено рисование петли в режиме игры
	Добавлено несколько рисунков


* 31 Oct 2009

	Добавлена текстура бумаги
	Произведена оптимизация определения столкновений
	Рисование с учетом флагов, а не серым цветом
	Удаление объектов за пределами области видимости
	Добавлен эффект рисования
	Упрощено управление в режиме игры
	Автопереход на следующий рисунок


* 8 Nov 2009

	Устранен баг: Ошибка в пересчете bbox
	Устранен баг: Возможность удалять объекты рисунка
	Устранен баг: SIGSEGV при удалении последнего объекта
	Произведена оптимизация определения столкновений
	Добавлен сброс эффекта рисования
	Доработано поведение сгибаемых объектов
	Доработано поведение веревок
	Устранен баг: Ошибка в оптимизации CCD
	Добавлены объекты заднего плана
	Добавлено несколько рисунков


* 16 Dec 2009

	Добавлен рестарт при потере возможности выиграть
	Устранен баг: Ошибка в CCD для петли
	Добавлена возможность отключения создания связей
	Добавлено несколько рисунков
	Исправлено несколько старых рисунков


* 25 Dec 2009

	Добавлена английская версия README
	Список изменений теперь в CHANGELOG
	Этот файл более не поддерживается


				АДРЕСА

Хотите помочь? пишите сюда,

email: amaora@yandex.ru
jID: amaora@jabber.ru

