# -*- coding: utf-8 -*-
#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

import os
import urllib2
import urlparse
from logging import getLogger
from time import time, mktime
from datetime import datetime

from ecore import timer_add

from downloadmanager.constants import DownloadState

from terra.core.manager import Manager
from terra.core.model import ModelFolder
from terra.core.task import Task
from terra.utils.encoding import to_utf8
from terra.core.plugin_prefs import PluginPrefs
from sqlite3 import OperationalError

__all__ = ("VideocastModelFolder", "VideoOnDemandFolder",)


log = getLogger("plugins.canola-core.videocast")
mger = Manager()
db = mger.canola_db

VideoModel = mger.get_class("Model/Media/Video")
FatalError = mger.get_class("Model/Notify/Error/Fatal")
DefaultIcon = mger.get_class("Icon")
OptionsModelFolder = mger.get_class("Model/Options/Folder")
OptionsActionModel = mger.get_class("Model/Options/Action")
VideoFeedListOptionsModel = \
    mger.get_class("Model/Options/Folder/Media/Feeds/Video")
OnDemandFolderOptionsModel = \
    mger.get_class("Model/Options/Folder/Media/OnDemand")


class VideocastIcon(DefaultIcon):
    terra_type = "Icon/Folder/Task/Video/OnDemand"
    icon = "icon/main_item/video_videocast"


OnDemandMixin = mger.get_class("Model/Media/Generic/OnDemand")
class VideoOnDemandModel(OnDemandMixin, VideoModel):
    terra_type = "Model/Media/Video/OnDemand"
    item_table = "videocast_episodes"
    feed_table = "videocast_feeds"
    download_group = "videocast"

    def __init__(self, parent):
        OnDemandMixin.__init__(self, parent)
        VideoModel.__init__(self)
        self.parent = parent # reset parent here as VideoModel annuls it.


OnDemandFolder = mger.get_class("Model/Folder/Media/OnDemand")
class VideoOnDemandFolder(OnDemandFolder):
    terra_type = "Model/Folder/Media/OnDemand/Video"
    item_table = "videocast_episodes"
    feed_table = "videocast_feeds"
    model_cls = VideoOnDemandModel

    def __get_id(self):
        return self._id

    def __set_id(self, value):
        self._id = int(value)
        path = PluginPrefs("settings").get("cover_path")
        self.cover = os.path.join(path, "videocasts/%d/cover.jpg" % int(value))

    id = property(__get_id, __set_id)

    def is_acceptable_format(self, uri):
        uri = uri.split("?")[0]
        ext = uri.split(".")[-1]
        for ext in ['mp4', 'm4v', 'ogg', 'wmv', 'avi', 'mov', 'mpg']:
            if uri.lower().endswith(ext):
                return True
        return False

    def options_model_get(self, controller):
        return VideoFeedListOptionsModel(None, controller)


TodaysEpisodesGenericOnDemandFolder = \
    mger.get_class("Model/Folder/Media/OnDemand/Generic/TodaysEpisodes")
class TodaysEpisodesVideoOnDemandFolder(TodaysEpisodesGenericOnDemandFolder):
    terra_type = "Model/Folder/Media/OnDemand/Video/TodaysEpisodes"
    model_cls = VideoOnDemandModel
    feed_cls = VideoOnDemandFolder


NewEpisodesGenericOnDemandFolder = \
    mger.get_class("Model/Folder/Media/OnDemand/Generic/NewEpisodes")
class NewEpisodesVideoOnDemandFolder(NewEpisodesGenericOnDemandFolder):
    terra_type = "Model/Folder/Media/OnDemand/Audio/NewEpisodes"
    model_cls = VideoOnDemandModel


CurrentDownloadsGenericOnDemandFolder = \
    mger.get_class("Model/Folder/Media/OnDemand/Generic/CurrentDownloads")
class CurrentDownloadsVideoOnDemandFolder(CurrentDownloadsGenericOnDemandFolder):
    terra_type = "Model/Folder/Media/OnDemand/Generic/CurrentDownloads/Video"
    model_cls = VideoOnDemandModel
    feed_cls = VideoOnDemandFolder
    watched_groups = ['videocast']


FeedFolder = mger.get_class("Model/Folder/Media/Feeds")
class VideoFeedFolder(FeedFolder):
    terra_type = "Model/Folder/Media/Feeds/Video"
    title = "My feeds"
    feed_cls = VideoOnDemandFolder
    model_cls = VideoOnDemandModel


OnDemandTaskFolder = mger.get_class("Model/Folder/Task/Generic/OnDemand")
class VideocastTaskFolder(OnDemandTaskFolder):
    terra_task_type = "Task/Videocast"
    terra_type = "Model/Folder/Task/Video/OnDemand"
    title = "Videocasts"
    preset_section = "Videocasts"
    feed_cls = VideoOnDemandFolder
    model_cls = VideoOnDemandModel

    def __init__(self, parent):
        OnDemandTaskFolder.__init__(self, parent)

    def do_load(self):
        VideoFeedFolder(self)
        TodaysEpisodesVideoOnDemandFolder(self)
        NewEpisodesVideoOnDemandFolder(self)
        CurrentDownloadsVideoOnDemandFolder(self)
