#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

import logging

from terra.core.manager import Manager

mger = Manager()
AudioOTGModelFolder = mger.get_class("Model/Folder/Media/Audio/Local/Playlist/OnTheGo")
OnTheGoAudioHooklist = mger.get_class("OnTheGo/Audio/Hooklist")
BaseTaskController = mger.get_class("TaskController")

log = logging.getLogger("plugins.canola-core.audio.task")

class LocalAudioTaskController(BaseTaskController):
    terra_type = "TaskController/Audio/Local"
    player_type = "Player/Audio"

    def __init__(self, task, parent, multitask):
        # Hang a persistent OTG instance to keep playlist alive.
        self._otg = AudioOTGModelFolder()
        self._otg.load()
        self.otg_hooks = OnTheGoAudioHooklist()
        BaseTaskController.__init__(self, task, parent, multitask)

    def killtree(self, notify):
        BaseTaskController.killtree(self, notify)
        self.otg_hooks.delete()
        self.otg_hooks = None
        self._otg.unload()
        # As the OnTheGoMF is a singleton, it'll never die nor have
        # its state_reason cleared automatically, thus we force that.
        self._otg.state_reason = None
        self._otg = None

    def must_hold(self):
        return bool(self._otg and self._otg.children) \
            or BaseTaskController.must_hold(self)

    def get_playing_model(self):
        try:
            return self.multitask.players[self.player_type].player.model
        except KeyError:
            return None

    def kill_player(self):
        try:
            self.multitask.players[self.player_type]._remove_player_state()
        except KeyError:
            log.debug_error("No player found with type: %s" % self.player_type)
