#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

import logging
log = logging.getLogger("plugins.canola-core.settings.main_menu")

from terra.core.manager import Manager
from terra.core.plugin_prefs import PluginPrefs

mger = Manager()
SettingsModelFolder = mger.get_class("Model/Settings/Folder")
SettingsActionModel = mger.get_class("Model/Settings/Action")
CheckedFolderController = mger.get_class("Controller/Settings/CheckedFolder")
MainMenuModelFolder = mger.get_class("Model/Folder/MainMenu")


class MainMenuPluginModel(SettingsActionModel):
    pref_key = "disabled_plugins"

    def __init__(self, parent, model):
        self.model = model
        self.name = model.title
        SettingsActionModel.__init__(self, parent)

        self.checked = not model.terra_type in self._disabled_plugins_get()

    def _disabled_plugins_get(self):
        prefs = PluginPrefs("settings")
        return prefs.get(self.pref_key, [])

    def _disabled_plugins_set(self, disabled_plugins):
        prefs = PluginPrefs("settings")
        prefs[self.pref_key] = disabled_plugins
        prefs.save()

    def execute(self):
        disabled_plugins = self._disabled_plugins_get()

        if self.model.terra_type in disabled_plugins:
            disabled_plugins.remove(self.model.terra_type)
            self.checked = True
        else:
            disabled_plugins.append(self.model.terra_type)
            self.checked = False

        self._disabled_plugins_set(disabled_plugins)


class MainMenuSettingsController(CheckedFolderController):
    terra_type = "Controller/Settings/Folder/Root/MainMenu"

    def __init__(self, model, canvas, parent):
        CheckedFolderController.__init__(self, model, canvas, parent)
        self.view.header_text = \
            "Changes will take effect after restarting Canola."

    def callback_item_data(self, model):
        return (model.name, model.checked)


class MainMenuSettingsModelFolder(SettingsModelFolder):
    terra_type = "Model/Settings/Folder/Root/MainMenu"
    title = "Main Menu"

    def do_load(self):

        for model in MainMenuModelFolder().tasks:
            try:
                MainMenuPluginModel(self, model)
            except AttributeError, e:
                log.debug_error("Attribute 'title' must be declared in %s. Skipping...", model)
