#! /usr/bin/python
# - coding: utf-8 -*-

# Copyright (c) 2010-2010 Renato Chencarek. All rights reserved.
#
# Author: Renato Chencarek <renato.chencarek@openbossa.org>
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
# PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import os, gconf
from math import ceil

class CanolaLayout:

    def __init__(self, nItems, width=800, height=600, iconW=96, iconH=96):
        self.nItems = nItems
        self.maxSize = [width/iconW, height/iconH]
        self.maxDiff = 1.4

    def idealBox(self, rows):

        setup = [0, 0]
        columns = int(round(rows * 1.618))

        if rows > self.maxSize[0]:
            setup[0] = self.maxSize[0]
        else:
            setup[0] = rows

        if columns > self.maxSize[1]:
            setup[1] = self.maxSize[1]
        else:
            setup[1] = columns

        return setup

    def layout(self):
        result = []
        box = [0, 0]
        items = 0

        while (True):
            items += 1
            box = self.idealBox(items)

            if box[0] * box[1] < self.nItems:
                continue

            r = ceil(float(self.nItems) / box[1])
            while r <= box[0]:
                lRow = ceil(self.nItems / r)
                sRow = self.nItems - ((r - 1) * lRow)

                if sRow < 0:
                    r += 1
                    continue

                if (float(lRow) / sRow) <= self.maxDiff or box == self.maxSize:
                    for i in range(int(r - 1)):
                        result.append(lRow)
                    result.append(sRow)
                    return result

                r += 1

        return result


def sort_keys(x, y):
    if x[1][1] - y[1][1] > 80:
        return 1
    if y[1][1] - x[1][1] > 80:
        return -1
    if x[1][0] < y[1][0]:
        return -1
    if y[1][0] < x[1][0]:
        return 1
    return 0

client = gconf.client_get_default()
views = {}

width = 800
height = 480
iconW = 96
iconH = 96

for item in client.all_dirs("/apps/osso/hildon-desktop/applets"):
    if "TaskShortcut:" in item:
        key = client.get_int(item + "/view")
        if key not in views.keys():
            views[key] = []

        shortcuts = views[key]

        name = item + "/position"
        shortcuts.append((name, client.get_list(name, gconf.VALUE_INT)))
        shortcuts.sort(sort_keys)

for p in shortcuts:
    print p

for key in views.keys():
    shortcuts = views[key]

    layout = CanolaLayout(len(shortcuts), width,
                          height, iconW, iconH).layout()

    nRows = len(layout)
    rowSize = (height / (nRows + 1))

    nCols = int(layout[0])
    colSize = (width / (nCols + 1))

    delta = (nCols - layout[nRows - 1]) * colSize / 2

    item = 0
    for i in range(nRows):
        y = ((i + 1) * rowSize) - iconH / 2
        nCols = int(layout[i])
        for j in range(nCols):
            x = ((j + 1) * colSize) - iconW / 2
            if i == nRows - 1:
                x += delta
            client.set_list(shortcuts[item][0], gconf.VALUE_INT, [x, y])
            item += 1

os.system("killall -9 hildon-desktop")
