/*
	Author: Heikki Holstila, heikki.holstila@gmail.com
	Thanks to hopbeat for ctrl-backspace emulation code.


    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <libhal.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>

const char *hal_udi_camfocus = "/org/freedesktop/Hal/devices/platform_cam_focus";
const char *hal_udi_shutter = "/org/freedesktop/Hal/devices/platform_cam_shutter";

GMainLoop *g_loop = NULL;
DBusConnection *dbus_sess;
DBusConnection *dbus_sys;
DBusMessage *msg_dashboard;
DBusError dbus_err;
static LibHalContext *halctx;
int shutter_state = 0;
Display *dpy;

static void signal_quitter(int sig)
{
	if( g_loop != NULL ) {
		g_main_loop_quit( g_loop );
	}
}

static void send_ctrl_backspace()
{
    // 37 - ctrl
    // 22 - backspace

    int keycode = 37;
    int is_down = 1;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    keycode = 22;
    is_down = 1;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    keycode = 22;
    is_down = 0;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    keycode = 37;
    is_down = 0;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);
}

static void property_modified( LibHalContext *ctx, const char *udi, const char *key,
                            dbus_bool_t is_removed, dbus_bool_t is_added)
{
    //printf("hal property callback %s: %s\n", udi, key);
	int state = libhal_device_get_property_bool(halctx, udi, "button.state.value", &dbus_err);

	if( strcmp(udi, hal_udi_shutter)==0 )
	{
	    shutter_state = state;
		//printf("shutter: %i\n",shutter_state);
	}

	if( strcmp(udi, hal_udi_camfocus)==0 && shutter_state==1 && state==1 )
	{
		//printf("focus key down\n");

		// we use ctrl-backspace emulation instead of dbus now
        //dbus_connection_send(dbus_sess, msg_dashboard, NULL);
        //dbus_connection_flush(dbus_sess);

		send_ctrl_backspace();
	}
}

int main()
{
	g_loop = g_main_loop_new( NULL, FALSE );
	if( g_loop == NULL ) {
		printf("glib main loop init failure\n");
		exit(EXIT_FAILURE);
	}

	dpy = XOpenDisplay(NULL);
	if ( dpy == NULL )
	{
		printf("failed to open display\n");
		exit(EXIT_FAILURE);
	}

/*  // not using session dbus anymore

	dbus_error_init( &dbus_err );
	dbus_sess = dbus_bus_get( DBUS_BUS_SESSION, &dbus_err );
	if ( dbus_error_is_set(&dbus_err) || dbus_sess==NULL ) {
		printf("session dbus init fail\n");
		exit(EXIT_FAILURE);
	}
	msg_dashboard = dbus_message_new_signal(
		"/com/nokia/hildon_desktop",
		"com.nokia.hildon_desktop",
		"exit_app_view" );
	if( msg_dashboard == NULL ) {
		printf("dbus msg fail\n");
		exit(EXIT_FAILURE);
	}
	dbus_message_set_no_reply(msg_dashboard, TRUE);
*/

	halctx = libhal_ctx_new();
	dbus_sys = dbus_bus_get(DBUS_BUS_SYSTEM, &dbus_err);
	    if ( dbus_error_is_set(&dbus_err) || dbus_sys==NULL ) {
        printf("system dbus init fail\n");
        exit(EXIT_FAILURE);
    }
	dbus_connection_setup_with_g_main(dbus_sys, NULL);
	if( !libhal_ctx_set_dbus_connection(halctx, dbus_sys) )
	{
		printf("hal dbus connection fail\n");
		exit(EXIT_FAILURE);
	}
    if( !libhal_ctx_init(halctx, &dbus_err) )
    {
        printf("hal init fail: %s\n", dbus_err.message);
        exit(EXIT_FAILURE);
    }

    libhal_ctx_set_device_property_modified(halctx, property_modified);
    libhal_device_add_property_watch(halctx, hal_udi_shutter, &dbus_err);
    libhal_device_add_property_watch(halctx, hal_udi_camfocus, &dbus_err);

	signal( SIGINT, &signal_quitter );
	signal( SIGQUIT, &signal_quitter );
	signal( SIGTERM, &signal_quitter );

/*	
	// upstart seems to prefer to have this not daemonized
    
	pid_t pid, sid;
    pid = fork();
    if( pid<0) {
        printf("fork failed\n");
        exit(EXIT_FAILURE);
    } else if( pid>0 ) {
        exit(EXIT_SUCCESS);
    }
    umask(0);
    sid = setsid();
    if( sid<0 ) {
        exit(EXIT_FAILURE);
    }
    if((chdir("/")) < 0) {
        exit(EXIT_FAILURE);
    }
    close( STDIN_FILENO );
    close( STDOUT_FILENO );
    close( STDERR_FILENO );
*/

	shutter_state = libhal_device_get_property_bool(halctx, hal_udi_shutter,
    	"button.state.value", &dbus_err);

	g_main_loop_run( g_loop );

    libhal_device_remove_property_watch(halctx, hal_udi_shutter, &dbus_err);
    libhal_device_remove_property_watch(halctx, hal_udi_camfocus, &dbus_err);
    libhal_ctx_shutdown(halctx, &dbus_err);
    libhal_ctx_free(halctx);
    dbus_connection_unref(dbus_sys);

   // dbus_message_unref(msg_dashboard);
   // dbus_connection_unref(dbus_sess);

    return EXIT_SUCCESS;
}
