/*
 * callforwarding - Call forwarding control panel applet for N900
 * Copyright (C) 2009  Mikko Mehtonen <mikko.mehtonen@vincit.fi>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 * 
 */

#include <stdio.h>
#include <hildon/hildon.h>
#include <locale.h>
#include <config.h>
#include <glib/gi18n.h>

#include "maindialog.h"
#include "callforwardingdialog.h"
#include "callforwarding.h"

#define _(String) gettext (String)

static void button_clicked (HildonButton *button, gpointer type);
static void remove_all_clicked (GtkWidget *button, gpointer type);
static GtkWidget *create_button (gchar *text, GCallback callback, gpointer type);
static void dialog_response (GtkDialog *dialog,
                             gint response,
                             gpointer user_data);


static GtkWidget *dialog;

void maindialog_show (GtkWindow *parent)
{
  GtkWidget *button;
  GtkWidget *label;
  GtkWidget *vbox;

  dialog = gtk_dialog_new_with_buttons (
                              _("Call forwarding"),
                              parent, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT |
                                      GTK_DIALOG_NO_SEPARATOR,
                              NULL);
  g_signal_connect (G_OBJECT(dialog), "response",
                    G_CALLBACK(dialog_response), NULL);

  vbox = gtk_vbox_new (FALSE, HILDON_MARGIN_DEFAULT);

  /* Instructions */
  label = gtk_label_new (_("Select setting to edit"));
  gtk_box_pack_start (GTK_BOX(vbox), label, FALSE, FALSE, 0);

  /* Busy */
  static gint busy = SS_DIVERT_BUSY;
  button = create_button (_("Busy"), G_CALLBACK(button_clicked), &busy);
  gtk_box_pack_start (GTK_BOX(vbox), button, FALSE, FALSE, 0);

  /* No answer */
  static gint no_answer = SS_DIVERT_NO_REPLY;
  button = create_button (_("No answer"), G_CALLBACK(button_clicked), &no_answer);
  gtk_box_pack_start (GTK_BOX(vbox), button, FALSE, FALSE, 0);

  /* Out of reach */
  static gint no_reach = SS_DIVERT_NO_REACH;
  button = create_button (_("Out of reach"), G_CALLBACK(button_clicked), &no_reach);
  gtk_box_pack_start (GTK_BOX(vbox), button, FALSE, FALSE, 0);

  /* Not available */
  static gint not_available = SS_DIVERT_NO_AVAIL;
  button = create_button (_("Not available"), G_CALLBACK(button_clicked), &not_available);
  gtk_box_pack_start (GTK_BOX(vbox), button, FALSE, FALSE, 0);

  /* Unconditional */
  static gint unconditional = SS_DIVERT_ALL;
  button = create_button (_("Unconditional"), G_CALLBACK(button_clicked), &unconditional);
  gtk_box_pack_start (GTK_BOX(vbox), button, FALSE, FALSE, 0);

  /* Remove all */
  button = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, 
                                        HILDON_BUTTON_ARRANGEMENT_HORIZONTAL, 
                                        _("Remove all"), NULL);
  g_signal_connect (G_OBJECT(button), "clicked", G_CALLBACK(remove_all_clicked), NULL);
  gtk_box_pack_start (GTK_BOX(vbox), button, FALSE, FALSE, 0);

  GtkWidget *area = hildon_pannable_area_new ();
  hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA(area), vbox);

  gtk_container_add (GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), area);
  gtk_window_set_default_size (GTK_WINDOW(dialog), -1, 360);
  gtk_widget_show_all (dialog);
}

static GtkWidget *create_button (gchar *text, GCallback callback, gpointer type)
{
  GtkWidget *button = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, 
                                                   HILDON_BUTTON_ARRANGEMENT_HORIZONTAL, 
                                                   text, NULL);
  g_signal_connect (G_OBJECT(button), "clicked", callback, type);
  return button;
}

static void button_clicked (HildonButton *button, gpointer type)
{
  const gchar *text = hildon_button_get_title (button);
  gint calltype = *(gint *)type;
  callforwardingdialog_show (GTK_WINDOW(dialog), text, calltype);
}

static void callforwarding_cancel_all_reply (GError *error)
{
  static gboolean first = TRUE;
  if (first)
  {
    first = FALSE;
    callforwarding_cancel (1, callforwarding_cancel_all_reply);
    return;
  }

  hildon_gtk_window_set_progress_indicator (GTK_WINDOW(dialog), FALSE);
  gtk_widget_set_sensitive (GTK_WIDGET(dialog), TRUE);
  first = TRUE;
}

static void remove_all_response (GtkDialog *confirmation,
                                 gint response,
                                 gpointer user_data)
{
  gtk_widget_hide_all (GTK_WIDGET(confirmation));
  if (response == GTK_RESPONSE_OK)
  {
    hildon_gtk_window_set_progress_indicator (GTK_WINDOW(dialog), TRUE);
    gtk_widget_set_sensitive (GTK_WIDGET(dialog), FALSE);
    callforwarding_cancel (5, callforwarding_cancel_all_reply);
  }
  gtk_widget_destroy (GTK_WIDGET(confirmation));
}

static void remove_all_clicked (GtkWidget *button, gpointer type)
{
  GtkWidget *confirm = hildon_note_new_confirmation (
                        GTK_WINDOW(dialog),
                        _("Remove all?"));
  g_signal_connect (G_OBJECT(confirm), "response",
                    G_CALLBACK(remove_all_response), NULL);
  gtk_widget_show_all (confirm);
}

static void dialog_response (GtkDialog *dialog,
                             gint response,
                             gpointer user_data)
{
  switch (response)
  {
    case GTK_RESPONSE_OK:
      break;

    default:
      gtk_widget_destroy (GTK_WIDGET(dialog));
  }
  gtk_main_quit ();
}
