#ifndef _CALLFORWARDING_H__
#define _CALLFORWARDING_H__

#include <gtk/gtk.h>
#include <dbus/dbus-glib.h>


/* Callback for call forwarding status query */
typedef void (*callforwarding_status_cb)(GError *error, gboolean status, gchar *number);

/* Query call forwarding status */
void callforwarding_get_status (gint type, callforwarding_status_cb cb);


/* Callback for cancel call forwarding */
typedef void (*callforwarding_cancel_cb)(GError *error);

/* Cancel call forwarding */
void callforwarding_cancel (gint type, callforwarding_cancel_cb cb);


/* Callback for activate call forwarding */
typedef void (*callforwarding_activate_cb)(GError *error);

/* Activate call forwarding */
void callforwarding_activate (gint type, const gchar *number, gint time, callforwarding_activate_cb cb);


void callforwarding_cancel_pending_call (void);

#endif
