#include "importlistwindow.h"

ImportListWindow::ImportListWindow(const QMap<QString, QString> &contacts, QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_DeleteOnClose);
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    QWidget *centralWidget = new QWidget();
    QVBoxLayout *lay = new QVBoxLayout(centralWidget);
    lay->setSpacing(8);
    lay->setContentsMargins(0, 0, 0, 0);
    QMaemo5EditBar *eb = new QMaemo5EditBar(tr("Choose contacts to import"));
    lay->addWidget(eb);
    QPushButton *pb = new QPushButton(tr("Import"));
    QPushButton *pball = new QPushButton(tr("Import all"));
    eb->addButton(pb);
    eb->addButton(pball);
    importlist = new QListWidget(centralWidget);
    importlist->setSelectionMode(QListWidget::MultiSelection);
    connect(pb, SIGNAL(clicked()), this, SLOT(importItems()));
    connect(pball, SIGNAL(clicked()), this, SLOT(importAll()));
    lay->addWidget(importlist);
    setCentralWidget(centralWidget);
    setWindowState(windowState() | Qt::WindowFullScreen);
    populateList(contacts);
}

ImportListWindow::~ImportListWindow()
{
}

void ImportListWindow::populateList(const QMap<QString, QString> &contacts)
{
    QListWidgetItem *item;
    QLabel *label;
    QMapIterator<QString, QString> i(contacts);
    while (i.hasNext()) {
        i.next();
        numberList.append(i.key());
        label = new QLabel(tr("%1<br><font size=\"1\" color=\"gray\">%2</font></br>").arg(i.value()).arg(i.key()), importlist);
        label->setStyleSheet("margin-left: 15px;");
        item = new QListWidgetItem(importlist);
        importlist->setItemWidget(item, label);
    }
}

void ImportListWindow::importItems()
{
    QStringList selectedItems;
    for (int i = 0; i < importlist->count(); ++i) {
        if (importlist->item(i)->isSelected()){
            selectedItems.append(numberList.at(i));
        }
    }
    if (selectedItems.isEmpty()){
        return;
    }
    else {
        int reply = QMessageBox::question(this, " ", tr("Import selected items?"), QMessageBox::Yes | QMessageBox::No, QMessageBox::No);
        if (reply == QMessageBox::Yes){
            emit returnList(selectedItems);
            close();
        }
    }
}

void ImportListWindow::importAll()
{
    int reply = QMessageBox::question(this, " ", tr("Import all contacts?"), QMessageBox::Yes | QMessageBox::No, QMessageBox::No);
    if (reply == QMessageBox::Yes){
        emit returnList(numberList);
        close();
    }
}
