#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include <QMainWindow>
#include <QDBusConnection>
#include <QDBusInterface>
#include <QDBusReply>
#include <QSettings>
#include <QMaemo5EditBar>
#include <QProcess>
#include <QMaemo5InformationBox>
#include "settingdialog.h"
#include "editlistwidget.h"

#define APP_VERSION "0.0.3"
#define BUS_NAME "org.callerx.ifdbus"
#define BUS_PATH "/org/callerx/ifdbus"
#define INSTANCE_INTERFACE "com.nokia.csd.Call.Instance"
#define DEFAULT_WHITELIST "/home/user/MyDocs/whitelist.txt"
#define DEFAULT_BLACKLIST "/home/user/MyDocs/blacklist.txt"


class MainWindow : public QMainWindow
{
    Q_OBJECT
public:

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

private slots:
    /* Ui related methods */
    void setupMenus();
    void setupUi();

    /* Setting methods */
    void readSettings();

    /* CallerxDaemon related methods */
    void daemonSwitch(QAction *);
    void loadWhiteListDaemon();
    void loadBlackListDaemon();
    void callerxDaemon(const QString&);
    bool callerxDaemonRunning();
    void inBoundCallUpdate(const QString&);

    /* Other methods */
    void beBusy(bool);
    void openLists();
    void newList();
    void addList();
    void recentInboundList();
    void clearInboundCallLog();
    void statusBarUpdate();
    QString cleanString(const QString&, bool prefix);
    void editSettings();
    void showList(QListWidgetItem*);
    void delList();
    void inboundlistaddtolist();
    void inboundlistdelete();
    void about() const;

private:
    QListWidget *listWidget, *inboundlist;
    QLabel *statusLabel;
    QAction *actEnable, *actDisable;
    QAction *delSelected, *settingAction, *inboundaddtolist, *inbounddelete;
    QString listPath, whitelistpath, blacklistpath, daemonversion;
    bool whitelistmode, daemonenabled, daemonautostart;
    QStringList recentCalls, customlistspath;
    QPushButton *recentInboundCall, *mLists;
};
#endif // MAINWINDOW_H
