/* 
   Copyright (C) 2011 Ove Kaaven

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

#include "settings.h"
#include "lookup.h"
#include "notify.h"
#include "monitor.h"
#include <stdio.h>
#include <string.h>
#include <glib.h>

static void usage(void)
{
  printf("Usage: callerid <number>\n");
}

int
main (int argc, char **argv)
{
  const char *home_dir;

  g_set_prgname("callerid");
  g_set_application_name("Caller ID");

  home_dir = g_getenv("HOME");
  if (!home_dir) home_dir = g_get_home_dir();

  /* Load settings */
  load_settings(home_dir);

  prepare_lookup();
  prepare_notify();

  if (argc > 1) {
    char *arg = argv[1];
    if (arg[0] == '-') {
      if (!strcmp(arg, "--daemon")) {
        /* Daemon mode */
        prepare_monitor();
        run_monitor();
        cleanup_monitor();
      }
      else {
        usage();
      }
    } else {
      /* Immediate mode */
      char *mcc = NULL;
      if (arg[0] != '+') {
        /* MCC lookup only needed if the number doesn't have a country code */
        mcc = get_current_mcc();
        if (!mcc) {
          fprintf(stderr, "Could not detect country code (try adding it with a '+' prefix)\n");
        }
      }
      show_id(lookup(arg, mcc));
      g_free(mcc);
    }
  }
  else {
    usage();
  }

  cleanup_notify();
  cleanup_lookup();
  unload_settings();

  return 0;
}
