/*
 *  calendar home widget for the maemo desktop.
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <libintl.h>
#include <locale.h>
#include <CMulticalendar.h>
#include <hildon/hildon.h>
#include "cal-home-settings-dlg.h"
#include "cal-home-calendar-util.h"
#include "cal-home-load-and-store.h"

void
cal_widget_resize_for_cal_size(CalHomePlugin* desktop_plugin);

static GtkWidget*
create_calendar_colour_icon_image(CalendarColour colour, GtkIconSize icon_size)
{
  switch(colour)
  {
  case COLOUR_DARKBLUE:
    return gtk_image_new_from_icon_name("calendar_colors_darkblue", icon_size);
  case COLOUR_DARKGREEN:
    return gtk_image_new_from_icon_name("calendar_colors_darkgreen", icon_size);
  case COLOUR_DARKRED:
    return gtk_image_new_from_icon_name("calendar_colors_darkred", icon_size);
  case COLOUR_ORANGE:
    return gtk_image_new_from_icon_name("calendar_colors_orange", icon_size);
  case COLOUR_VIOLET:
    return gtk_image_new_from_icon_name("calendar_colors_violet", icon_size);
  case COLOUR_YELLOW:
    return gtk_image_new_from_icon_name("calendar_colors_yellow", icon_size);
  case COLOUR_BLUE:
    return gtk_image_new_from_icon_name("calendar_colors_blue", icon_size);
  case COLOUR_RED:
    return gtk_image_new_from_icon_name("calendar_colors_red", icon_size);
  case COLOUR_GREEN:
    return gtk_image_new_from_icon_name("calendar_colors_green", icon_size);
  default:
    return gtk_image_new_from_icon_name("calendar_colors_white", icon_size);
  }
}

void
show_visible_calendars_dlg(GtkButton* button, gpointer data)
{
  cal_settings_data_t* settings_data = (cal_settings_data_t*)data;
  GtkWidget *dialog;

  dialog = gtk_dialog_new_with_buttons("Settings",
				       NULL,
				       (GtkDialogFlags)0,
				       dgettext("hildon-libs", "wdgt_bd_done"),
				       GTK_RESPONSE_ACCEPT,
				       NULL);

  vector<CCalendar*> calendars = CMulticalendar::MCInstance()->getListCalFromMc();

  GtkWidget* content = gtk_dialog_get_content_area(GTK_DIALOG(dialog));
  GtkWidget* list_box = gtk_vbox_new(TRUE, 0);
  GtkWidget* check_buttons[calendars.size()];
  vector<CCalendar*>::iterator calendars_iter = calendars.begin();
  vector<CCalendar*>::iterator calendars_iter_end = calendars.end();
  int i = 0;
  while(calendars_iter!=calendars_iter_end)
  {
    GtkWidget* check_button = hildon_gtk_toggle_button_new(HILDON_SIZE_FINGER_HEIGHT);

    check_buttons[i] = check_button;      

    for(int k = 0;k<settings_data->number_visible_cals;++k)
    {
      if(settings_data->visible_cals[k]==(*calendars_iter)->getCalendarId())
      {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_button),
				     TRUE);
      }
    }

    gtk_button_set_label(GTK_BUTTON(check_button),
			 (*calendars_iter)->getCalendarName().c_str());

    GtkWidget* image = create_calendar_colour_icon_image((*calendars_iter)->getCalendarColor(),
							 HILDON_ICON_SIZE_FINGER);
    gtk_button_set_image(GTK_BUTTON(check_button), image);
    gtk_button_set_alignment(GTK_BUTTON(check_button),0 ,0);
    gtk_box_pack_start(GTK_BOX(list_box), check_button, TRUE, FALSE, 0);

    ++calendars_iter;
    ++i;
  }

  GtkWidget* pan = hildon_pannable_area_new();
  hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(pan), list_box);
  gtk_box_pack_start(GTK_BOX(content), pan, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(content), list_box, TRUE, TRUE, 0);
  gtk_window_set_default_size(GTK_WINDOW(dialog), -1, 325);  
  gtk_widget_show_all(dialog);

  if(gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT)
  {
    int visible_count = 0;
    for(int i=0;i<calendars.size();++i)
    {
      if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_buttons[i])))
	++visible_count;
    }
    g_free(settings_data->visible_cals);
    settings_data->number_visible_cals = visible_count;
    settings_data->visible_cals = g_new0(gint, visible_count);
    visible_count = 0;
    for(int i=0;i<calendars.size();++i)
    {
      if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_buttons[i])))
      {
	settings_data->visible_cals[visible_count] = calendars[i]->getCalendarId();
	++visible_count;
      }
    }
    gchar* button_value = g_strdup_printf("(%d)", settings_data->number_visible_cals); 
    hildon_button_set_value(HILDON_BUTTON(button),
			    button_value);
    g_free(button_value);

  }
  CMulticalendar::MCInstance()->releaseListCalendars(calendars);
  gtk_widget_destroy(dialog);
}

void
cal_show_settings_dialog(GtkWidget* widget, gpointer data)
{
  CalHomePlugin *desktop_plugin = CAL_HOME_PLUGIN(widget);

  GtkWidget *dialog;

  dialog = gtk_dialog_new_with_buttons("Settings",
				       NULL,
				       (GtkDialogFlags)0,
				       dgettext("hildon-libs", "wdgt_bd_done"),
				       GTK_RESPONSE_ACCEPT,
				       NULL);

  GtkWidget *cal_time_selector = hildon_touch_selector_new_text();
  GtkWidget *launch_view_selector = hildon_touch_selector_new_text();
  GtkWidget *cal_size_selector = hildon_touch_selector_new_text();

  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(launch_view_selector), 
				    dgettext("calendar", "cal_me_toggle_month"));
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(launch_view_selector), 
				    dgettext("calendar", "cal_me_toggle_week"));
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(launch_view_selector), 
				    dgettext("calendar", "cal_me_toggle_agenda"));

  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(cal_size_selector),
				    "Auto");
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(cal_size_selector),
				    dgettext("osso-sharing-ui", "share_fi_options_size_large"));
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(cal_size_selector),
				    dgettext("osso-sharing-ui", "share_fi_options_size_medium"));
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(cal_size_selector),
				    dgettext("osso-sharing-ui", "share_fi_options_size_small"));

  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(cal_time_selector),
				    "1 Week");
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(cal_time_selector),
				    "2 Weeks");
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(cal_time_selector),
				    "3 Weeks");
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(cal_time_selector),
				    "1 Month");
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(cal_time_selector),
				    "2 Month");
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(cal_time_selector),
				    "3 Month");
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(cal_time_selector),
				    "6 Month");
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(cal_time_selector),
				    "1 Year");


  GtkWidget* open_mode_button = hildon_picker_button_new(HILDON_SIZE_FINGER_HEIGHT,
							 HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
  
  GtkWidget* cal_size_button = hildon_picker_button_new(HILDON_SIZE_FINGER_HEIGHT,
							HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
  
  GtkWidget* cal_time_button = hildon_picker_button_new(HILDON_SIZE_FINGER_HEIGHT,
							HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
  
  GtkWidget* visible_calendar = hildon_button_new(HILDON_SIZE_FINGER_HEIGHT,
						  HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);

  hildon_button_set_style(HILDON_BUTTON(visible_calendar),
			  HILDON_BUTTON_STYLE_PICKER);

  hildon_button_set_title(HILDON_BUTTON(cal_size_button),
			  dgettext("hildon-libs", "ckdg_va_sort_size"));

  hildon_button_set_title(HILDON_BUTTON(cal_time_button),
			  "Visible Events");

  hildon_button_set_value(HILDON_BUTTON(visible_calendar),
			  g_strdup_printf("(%d)", desktop_plugin->number_visible_cals));

  hildon_button_set_title(HILDON_BUTTON(visible_calendar),
			  dgettext("calendar", "cal_fi_visible"));

  hildon_button_set_title(HILDON_BUTTON(open_mode_button),
			  dgettext("calendar", "cal_ia_wizard_typetext"));


  
  hildon_touch_selector_set_active(HILDON_TOUCH_SELECTOR(launch_view_selector),
				   0, desktop_plugin->launch_view -1);

  hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(open_mode_button),
				    HILDON_TOUCH_SELECTOR(launch_view_selector));
  
  hildon_touch_selector_set_active(HILDON_TOUCH_SELECTOR(cal_size_selector),
				   0, desktop_plugin->cal_size);

  hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(cal_size_button),
				    HILDON_TOUCH_SELECTOR(cal_size_selector));
  

  hildon_touch_selector_set_active(HILDON_TOUCH_SELECTOR(cal_time_selector),
				   0, desktop_plugin->cal_time_period);

  hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(cal_time_button),
				    HILDON_TOUCH_SELECTOR(cal_time_selector));
  
  cal_settings_data_t* settings_data = g_new0(cal_settings_data_t, 1);
  settings_data->number_visible_cals = desktop_plugin->number_visible_cals;
  settings_data->visible_cals = (gint*)g_memdup(desktop_plugin->visible_cals, 
					sizeof(gint)*desktop_plugin->number_visible_cals);
  
  g_signal_connect(G_OBJECT(visible_calendar), "clicked", 
		   G_CALLBACK(show_visible_calendars_dlg), settings_data);
  
  GtkWidget* content = gtk_dialog_get_content_area(GTK_DIALOG(dialog));

  gtk_box_pack_start(GTK_BOX(content), cal_time_button, FALSE, FALSE, 3);
  gtk_box_pack_start(GTK_BOX(content), cal_size_button, FALSE, FALSE, 3);
  gtk_box_pack_start(GTK_BOX(content), open_mode_button, FALSE, FALSE, 3);
  gtk_box_pack_start(GTK_BOX(content), visible_calendar, FALSE, FALSE, 3);

  gtk_widget_show_all(dialog);

  if(gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT)
  {
    desktop_plugin->number_visible_cals = settings_data->number_visible_cals;
    desktop_plugin->visible_cals = (gint*)g_memdup(settings_data->visible_cals, 
						   sizeof(gint)*settings_data->number_visible_cals);
    desktop_plugin->launch_view = hildon_touch_selector_get_active(HILDON_TOUCH_SELECTOR(launch_view_selector), 0) + 1;
    desktop_plugin->cal_size = CalSize(hildon_touch_selector_get_active(HILDON_TOUCH_SELECTOR(cal_size_selector), 0));
    desktop_plugin->cal_time_period = CalTimePeriod(hildon_touch_selector_get_active(HILDON_TOUCH_SELECTOR(cal_time_selector), 0));
    cal_home_save_settings(desktop_plugin);
    cal_home_load_db_events(desktop_plugin);
    cal_widget_resize_for_cal_size(desktop_plugin);
  }
  g_free(settings_data);
  gtk_widget_destroy (dialog);
}
