import urllib
import urllib2
from lxml import etree

CONSUMER_KEY = 'Q2GVIHOX6AA7GOV'
USER_AGENT = 'Firefox/3.5 Maemo Browser 1.5.6 RX-51 N900'
KEOLIS_URL = 'http://data.keolis-rennes.com/xml/'
KEOLIS_VERSION = "1.0"


class KeolisError(Exception):
    def __init__(self, value):
        self.value = value
    def __str__(self):
        return repr(self.value)
     

def get_all_stations():
    """Return all stations"""
    data = {'cmd' : 'getstation'}
    xml_data = get_data(data)
    return process_stations_result(xml_data)
    

def get_geo_stations(latitude, longitude):
    """Return nearest stations"""
    data = {'cmd' : 'getstation',
            'param[request]' : 'proximity',
            'param[mode]' : 'coord',
            'param[lat]' : latitude,
            'param[long]' : longitude}
    xml_data = get_data(data)
    return process_stations_result(xml_data)

    
def process_stations_result(xml_data):
    stations = []
    root = etree.XML(xml_data)
    for answer in root.iter('answer'):

        if answer.find('status').get('code') != '0':
            raise KeolisError(answer.find('status').get('message'))
        
        for station in root.iter('station'):
            stations.append({'name' : station.find('name').text,
                             'latitude' :  station.find('latitude').text,
                             'longitude' :  station.find('longitude').text,
                             'slotsavailable' :  station.find('slotsavailable').text,
                             'bikesavailable' :  station.find('bikesavailable').text,
                             'district' :  station.find('district').text,     
                             'pos' :  station.find('pos').text})
    return stations
    

def get_data(data=None):
    """Retrieve the specified url
    url : url to retrieve
    data : query parameters"""
    
    headers = {'User-Agent' : USER_AGENT}
    values = {'key' : CONSUMER_KEY,
              'version' : KEOLIS_VERSION}
    if data:
        values.update(data)
    url = KEOLIS_URL + '?' + urllib.urlencode(values)
    print url
    req = urllib2.Request(url,  None,  headers)
    xml_data = urllib2.urlopen(req).read()
    return xml_data[xml_data.find('<?xml version='):]
    
    
if __name__ == "__main__":
    print get_all_stations()
