#!/usr/bin/python
# -*- coding: utf-8 -*-

import pexpect
import hashlib
import os.path
import threading
import subprocess
import sys
import dbus
from dbus import glib
from dbus.mainloop.glib import DBusGMainLoop
import gobject
import pygst
import gst
import re
import ConfigParser
import shlex
import csv
import codecs

templates = []
replaces = []

config = ConfigParser.RawConfigParser()
config.read('/home/user/.cachetts.conf')
textmode = config.get('cachetts', 'textmode')
cachedir = config.get('cachetts', 'cachedir')
prefix = config.get('cachetts', 'prefix')
festival_init_cmd = config.get('cachetts', 'festival_init_cmd')
espeakcmd = config.get('cachetts', 'espeakcmd')
espeakcmd = shlex.split(espeakcmd)
 
templatesReader = csv.reader(open(config.get('cachetts', 'templates')), dialect=csv.excel)
for row in templatesReader:
	if len(row) != 2:
		continue
	templates.append([row[0],row[1]])

replaceReader = csv.reader(open(config.get('cachetts', 'replaces')), dialect=csv.excel)
for row in replaceReader:
	if len(row) != 2:
		continue
	replaces.append([row[0],row[1]])

class espeakGenerator:
	def gen(self, text):
		return sayTextEspeak(text)

class festivalGenerator:
	def gen(self, text):
		return sayTextFestival(text)

class festivalCacheGenerator:
	def gen(self, text):
		return sayFileFestivalCache(text)

# Just in case, if we need inheritance
class say:
	def __init__(self):
		return

class message:
	def __init__(self, urgent, tag, kickoff):
		self.urgent = urgent
		self.tag = tag
		# If true, this message should be discarded if message with the same flag arrives
		self.kickoff = kickoff
		# Every element is say*
		self.phrazes = []
	
	def get_phraze(self):
		if len(self.phrazes) == 0:
			return None
		ret = self.phrazes[0]
		self.phrazes = self.phrazes[1:]
		return ret

	def look_phraze(self):
		if len(self.phrazes) == 0:
			return None
		return self.phrazes[0]

class sayFile(say):
	def __init__ (self,file):
		say.__init__(self)
		self.file = file
	def fileToPlay(self):
		return self.file
	def say(self):
		return
	
class sayFileFestivalCache(sayFile):
	def __init__ (self,text):
		self.text = text
		sayFile.__init__(self, cachedir + hashlib.md5(self.text).hexdigest() + ".wav")
		self.lock = threading.Lock()
		if not os.path.isfile(self.file):
			self.lock.acquire()
			festival_generator.add(self)
	def release(self):
		self.lock.release()
	
	def fileToPlay(self):
		if self.lock.acquire(False):
			ret = sayFile.fileToPlay(self)
			self.lock.release()
		else:
			ret = False
		return ret
	def say(self):
		# fileToPlay was called before. If wav was generated, this function wouldn't be called
		if not backup_generator == None:
			backup = backup_generator.gen(self.text)
			ret = backup.say()
		else:
			self.lock.acquire()
			sayFile.say(self)
			self.lock.release()

class sayTextEspeak(say):
	def __init__ (self,text):
		say.__init__(self)
		self.text = text
	def fileToPlay(self):
		return False
	def say(self):
		p = subprocess.Popen(espeakcmd, stdin=subprocess.PIPE, stdout=subprocess.PIPE)
		p.communicate(self.text)

class sayTextFestival(say):
	def __init__ (self,text):
		say.__init__(self)
		self.text = text
	def fileToPlay(self):
		return False
	def say(self):
		festival_generator.say(self.text)

class soundGenerator(threading.Thread):
	def __init__ (self):
		threading.Thread.__init__(self)
		self.lock = threading.Semaphore()
		self.wait = threading.Semaphore()
		self.wait.acquire()
		self.waiting = False
		self.queue = []
		self.festivalLock = threading.Lock()
		self.festival = None

	def ensure_festival(self):
		self.festivalLock.acquire()
		if self.festival == None:
			self.festival = pexpect.spawn('nice', ["-n19", "festival"], 2)
			# First of all we set language
			self.festival.expect ('festival>', 3600)
			self.festival.sendline (festival_init_cmd)

			# Then we set callbacks to save output to files
			self.festival.expect ('festival>', 3600)
			self.festival.sendline ("(define (save_record_wave utt) (utt.save.wave utt outfile))")
			self.festival.expect ('festival>', 3600)
			self.festival.sendline ("(set! tts_hooks (list utt.synth save_record_wave))")
			self.festival.expect ('festival>', 3600)

	def close_festival(self):
		self.festivalLock.acquire()
		self.festival.sendline ("(exit)")
		self.festival.__del__()
		self.festival = None
		self.festivalLock.release()

	def add(self, item):
		self.lock.acquire()
		self.queue.append(item)
		if len(self.queue) == 1 and self.waiting:
			self.wait.release()
			self.waiting = False
		self.lock.release()

	def get(self):
		self.lock.acquire() 
		if len(self.queue) == 0:
			self.waiting = True
			self.lock.release()
			self.wait.acquire(True)	
			self.lock.acquire()
		res = self.queue[0]
		self.queue = self.queue[1:]
		self.lock.release()
		return res

	def run(self):	
		while True:
			item = self.get()
			if not os.path.isfile(item.file):
				self.ensure_festival()
				self.festival.sendline ("(set! outfile \""+item.file+"\")")

				self.festival.expect ('festival>', 3600)
				self.festival.sendline ("(tts_text \""+item.text+"\" \""+textmode+"\")")
				self.festival.expect ('festival>', 3600)
				self.festivalLock.release()
			item.release()	
	
	def say(self, text):
		self.ensure_festival()
		self.festival.sendline ("(SayText \""+text+"\")")
		self.festival.expect ('festival>', 3600)
		self.festivalLock.release()

class stringParser:
	def __init__ (self):
		self.player = gst.element_factory_make("playbin2", "player")
		fakesink = gst.element_factory_make("fakesink", "fakesink")
		self.player.set_property("video_sink", fakesink)
		bus = self.player.get_bus()
		bus.add_signal_watch()
		bus.connect("message", self.on_player_message)
		self.player.connect("about_to_finish", self.about_to_finish)
		
		self.messages = []
		self.caching = True

	def get_phraze(self):
		while True:
			if len(self.messages) == 0:
				return False
			phraze = self.messages[0].get_phraze()
			if phraze != None:
				return phraze
			self.messages = self.messages[1:]
	
	def look_phraze(self):
		while True:
			if len(self.messages) == 0:
				return None
			phraze = self.messages[0].look_phraze()
			if not phraze == None:
				return phraze
			self.messages = self.messages[1:]

	def on_player_message(self, bus, message):
		t = message.type
		if t == gst.MESSAGE_EOS or t == gst.MESSAGE_ERROR:
			self.player.set_state(gst.STATE_NULL)
			self.say_phrazes()

	def about_to_finish(self, ignored):
		phraze = self.look_phraze()
		if phraze:
			file = phraze.fileToPlay()
			if not file == False:
				self.player.set_property("uri", "file://" + file)
				self.get_phraze()

	def say_phrazes(self):
		phraze = self.get_phraze()
		while not phraze == False:
			file = phraze.fileToPlay()
			if not file == False:
				self.player.set_property("uri", "file://" + file)
				self.player.set_state(gst.STATE_PLAYING)
				break
			else:
				phraze.say() 
			phraze = self.get_phraze()

	def say_string(self, string, urgent, tag, kickoff):
		self.add_string_to_queue (string, urgent, tag, kickoff, self.caching, generator)

	def say_string_custom(self, string, urgent, tag, kickoff, caching, generator):
		self.add_string_to_queue (string, urgent, tag, kickoff, caching, get_generator(generator))

	def add_string_to_queue(self, string, urgent, tag, kickoff, caching, generator):
		msg = message(urgent, tag, kickoff)
		string = string.lower().encode("utf-8")
		offset = 0;

		for replacement in replaces:
			string = re.sub(replacement[0], replacement[1], string)

		print string
		
		if caching:
			while offset < len(string):
				# Where best candidate starts
				start = len(string)
				# Number of best candidate
				phraze = -1;
				for i in range(len(templates)):
					pos = string.find(templates[i][0], offset)
					if pos >= 0:
						if pos < start:
							phraze = i
							start = pos
							if start == offset:
								break

				if start > offset:
					subline = string[offset:start].strip()
					if len(subline) > 0:
						msg.phrazes.append(generator.gen(subline))
					offset = start
				
				if phraze >= 0:
					msg.phrazes.append(sayFile(prefix+templates[phraze][1]))
					offset += len(templates[phraze][0])
		else:
			msg.phrazes.append(generator.gen(string))

		if msg.kickoff:
			# Delete all messages with the same tag, excepting first message in queue, which is already beeng processed
			i = 1
			while i < len(self.messages):
				if self.messages[i].tag == msg.tag:
					self.messages = self.messages[:i-1]+self.messages[i+1:]
				else:
					i += 1
		if msg.urgent:
			i = 1
			while i < len(self.messages):
				if not self.mssages[i].urgent:
					break
			self.messages = self.messages[:i-1]+[msg]+self.messages[i:]
		else:
			self.messages.append(msg)
		
		if len(self.messages) == 1:
			self.say_phrazes()

	def set_caching (self, caching):
		if caching != True and caching != False:
			return False
		self.caching = caching
		return True

def get_generator (name):
	if name == "espeak":
		return espeakGenerator()
	elif name == "festival":
		return festivalGenerator()
	elif name == "festival_cache":
		return festivalCacheGenerator()
	else:
		return False

def set_generator (type, gen):
	global generator
	global backup_generator
	gen = get_generator(gen)
	if gen == False:
		return False
	
	if type == "main":
		generator = gen
	elif type == "backup":
		backup_generator = gen
	else:
		return False
	return True

gobject.threads_init()
glib.init_threads()

set_generator ("main", config.get('cachetts', 'generator'))
set_generator ("backup", config.get('cachetts', 'backup_generator'))

# Start background festival wav generator
festival_generator = soundGenerator()
festival_generator.start()

parser = stringParser()

bus = dbus.SystemBus()
signal = bus.add_signal_receiver(parser.say_string, path='/su/kibergus/cachetts',   dbus_interface='su.kibergus.cachetts', signal_name='say_string')
signal = bus.add_signal_receiver(parser.say_string_custom, path='/su/kibergus/cachetts',   dbus_interface='su.kibergus.cachetts', signal_name='say_string_custom')
signal = bus.add_signal_receiver(set_generator, path='/su/kibergus/cachetts',   dbus_interface='su.kibergus.cachetts', signal_name='set_generator')
signal = bus.add_signal_receiver(parser.set_caching, path='/su/kibergus/cachetts',   dbus_interface='su.kibergus.cachetts', signal_name='set_caching')
loop = gobject.MainLoop()
print "System started."
loop.run()
