#ifndef MAP_WIDGET_H
#define MAP_WIDGET_H

#include <QGraphicsGeoMap>
#include <QGeoMappingManager>
#include <QGeoMapPixmapObject>
#include <QGeoMapCircleObject>
#include <QGeoMapGroupObject>
#include <QGeoPositionInfo>
#include <QTimer>

#include "cache.h"
#include "iconloader.h"
#include "locationprovider.h"
#include "waypointdb.h"

#include "mapoverlay.h"
#include "mapbanner.h"
#include "mapspinner.h"
#include "mapbubble.h"

QTM_USE_NAMESPACE

class MapWidget : public QGraphicsGeoMap {
  Q_OBJECT;

 public:
  MapWidget(QGeoMappingManager*);
  ~MapWidget();
  void updateCaches(const CacheList &);
  void updateZoomButtons();
  void hideBubble();
  QString managerName();
  void paint(QPainter *, const QStyleOptionGraphicsItem *, QWidget * = 0);
  bool hiRez() const;
  void setHiRez(bool);
  void setWaypointDb(WaypointDb *);

 signals:
  void mapChanged();
  void cacheClicked(const QString &);
  void detailClicked(const QString &);
  void showMessage(const QString &);
  void fullscreen();
  
 public slots:
  void zoomIn();
  void zoomOut();
  void toggleFullscreen();
  void gpsFollow();
  void showBubble(const Cache &);
  void showBubble(const Waypoint &);
  void showDetails();
  void setBusy(bool);
  void addBanner(const QString &);
  
 private slots:
  void reloadCustomWaypoints();
  void reloadTimerExpired();
  void reload();
  void zoomLevelChangedEvent(qreal);
  void centerChangedEvent(const QGeoCoordinate &);
  void positionUpdated(const QGeoPositionInfo &);
  void positionUpdated(const QCompassReading *);
  
 protected:
  void mousePressEvent(QGraphicsSceneMouseEvent *);
  void mouseReleaseEvent(QGraphicsSceneMouseEvent *);
  void mouseMoveEvent(QGraphicsSceneMouseEvent *);
  void resizeEvent(QGraphicsSceneResizeEvent *);
  void showEvent(QShowEvent *);
  
 private:
  class MapCacheObject : public QGeoMapPixmapObject {
  public:
    MapCacheObject(IconLoader *, const Cache &, bool);
    bool contains( const QGeoCoordinate &) const;
  };

  class MapWaypointObject : public QGeoMapPixmapObject {
  public:
    MapWaypointObject(IconLoader *, const QString &, const Waypoint &);
    Waypoint waypoint() const;
  private:
    Waypoint m_wpt;
  };

  // this should actually be much lower on non-touch devices
  static const int DRAG_FUZZ = 30;
  
  QPointF m_downPos;
  IconLoader *m_iconLoader;
  MapOverlay *m_mapOverlay;
  MapBanner *m_mapBanner;
  MapSpinner *m_mapSpinner;
  QTimer *m_timer;
  MapBubble *m_bubble;
  QGeoBoundingBox m_currentViewport;
  bool m_dragging;
  bool m_posIsValid;
  bool m_gpsLocked;
  bool m_hiRez;
  int m_precisionAlpha;
  QString m_selectedCache;
  QList<Waypoint> m_selectedWaypoints;
  qreal m_compass;

  // make sure map is only updated if it's dragged
  // significantly
  QGeoCoordinate m_lastUpdateCenter;

  QGeoMapPixmapObject *m_gpsMarker;
  QGeoMapCircleObject *m_gpsPrecision;
  QGeoMapGroupObject *m_cacheGroup;
  QGeoMappingManager *m_manager;

  WaypointDb *m_wptDb;
  QList<Waypoint> m_customWpts;
};

#endif // MAP_WIDGET_H
