#ifndef CUSTOM_PIXMAP_H
#define CUSTOM_PIXMAP_H

#include <QPixmap>
#include <QSvgRenderer>
#include <QStringList>

class CustomPixmap: public QPixmap {
 public:
  enum State { Normal, Highlight, Greyscale };
  
  CustomPixmap(QSvgRenderer *, const QStringList &, int = 0);
  CustomPixmap(const QStringList &, int = 0, State = Normal);
  ~CustomPixmap();
  bool is(const QString &, State);
  QPoint offset();
  static QSize prepare(QSvgRenderer *, const QString &, int);

 private:
  static bool load(QSvgRenderer *, const QString &);

  QString m_name;
  State m_state;
  QPoint m_offset;
};

#endif // CUSTOM_PIXMAP_H
