#ifndef ICON_LOADER_H
#define ICON_LOADER_H

#include <QList>
#include <QPixmap>
#include <QString>
#include <QStringList>
#include <QSvgRenderer>

#include "cache.h"
#include "pixmap.h"

class IconLoader {
public:
  IconLoader(int);
  ~IconLoader();
  Pixmap *load(const QString &, int = 0);
  Pixmap *loadHighlight(const QString &, int = 0);
  Pixmap *load(const QStringList &, int = 0);
  Pixmap *loadHighlight(const QStringList &, int = 0);
  Pixmap *load(const Cache &, int = 0);
  Pixmap *loadHighlight(const Cache &, int = 0);
  Pixmap *load(const Container &, int = 0);
  int size() const;
  QWidget *newWidget(const QString &, int = 0);
  QWidget *newWidget(const QStringList &, int = 0);
  QWidget *newWidget(const Cache &, int = 0);

private:
  QSvgRenderer *m_renderer;
  int m_size;
  
  QList <Pixmap*> pixmapList;
};

#endif // ICON_LOADER_H
