#!/bin/bash
# try to fetch version info from changelog and adjust all other version occurances
CHANGELOG=./debian/changelog
STR=`grep -m1 "^[ ]*cacheme (" $CHANGELOG | awk '{ print $2 }' | tr -d '()'`
VERSION=`echo $STR | cut -d\- -f1 -`
RELEASE=`echo $STR | cut -d\- -f2 -`
echo "Detected version $VERSION with release $RELEASE"
echo "Adjusting cacheme-$VERSION/common.pri"
sed -e "s/^VERSION.*/VERSION = $VERSION/" common.pri > tmp ; mv tmp common.pri
echo "Adjusting cacheme-$VERSION/src/config.h"
sed -e "s/^#define VERSION.*/#define VERSION \"$VERSION\"/" src/config.h > tmp ; mv tmp src/config.h
