#ifndef ICON_LOADER_H
#define ICON_LOADER_H

#include <QList>
#include <QPixmap>
#include <QString>
#include <QStringList>
#include <QSvgRenderer>

#include "cache.h"

class IconLoader {
public:
  IconLoader(int);
  ~IconLoader();
  QPixmap *load(const QString &, int = 0);
  QPixmap *loadHighlight(const QString &, int = 0);
  QPixmap *load(const QStringList &, int = 0);
  QPixmap *loadHighlight(const QStringList &, int = 0);
  QPixmap *load(const Cache &, int = 0);
  QPixmap *loadHighlight(const Cache &, int = 0);
  QPixmap *load(const Container &, int = 0);
  int size() const;
  QWidget *newWidget(const QString &, int = 0);
  QWidget *newWidget(const QStringList &, int = 0);
  QWidget *newWidget(const Cache &, int = 0);

private:
  QSvgRenderer *m_renderer;
  int m_size;
  
  class Pixmap {
  public:
    enum State { Normal, Highlight, Greyscale };

    Pixmap(QSvgRenderer *, const QStringList &, int = 0);
    Pixmap(const QStringList &, int = 0, State = Normal);
    ~Pixmap();
    QPixmap *pixmap();
    bool is(const QString &, State);
    bool load(QSvgRenderer *, const QString &);
 
  private:
    QPixmap *m_pixmap;
    QString m_name;
    State m_state;
  };

  QList <Pixmap*> pixmapList;
};

#endif // ICON_LOADER_H
