#ifndef GPX_H
#define GPX_H

#include <QObject>
#include <QThread>

#include "cachelist.h"
#include "cacheproviderplugin.h"
#include "gpxfileparser.h"

class Gpx : public QObject, public CacheProviderPlugin {
 Q_OBJECT
 Q_INTERFACES(CacheProviderPlugin)
    
public:
  Gpx();
  ~Gpx();

  QString name();
  QString license();
  bool canBeDefault();
  QObject *object();

  void init(QWidget * = 0);
  void createConfig(QDialog *, QVBoxLayout*);

  bool busy();
  void processRequestOverview(const QGeoBoundingBox &, const int);
  void processRequestInfo(const QString &);
  void processRequestDetail(const QString &);

 private slots:
  void applyChanges();
  void fileParserFailed(const QString &);
  void fileParserSucceeded(const CacheList &);

 signals:
  void replyOverview(const CacheList &);
  void replyInfo(const Cache &);
  void replyDetail(const Cache &);
  void replyError(const QString &);
  void reload();
  void notifyBusy(bool);
  void done();
  void next();

  void fileParse(const QString &);

 private:
  void error(const QString &);

  CacheList m_cacheList;
  GpxFileParser *m_fileParser;
  QThread *m_thread;

  QString m_name;
  bool m_initialized;
  QString m_fileName;
};

#endif // GPX_H
