// Filename: descriptionwindow.cpp

#include <QDebug>
#include <QDesktopServices>

#include "htmlview.h"
#include "descriptionwindow.h"

DescriptionWindow::DescriptionWindow(const Cache &cache, QWidget *parent) : 
  CustomWindow("DescriptionWindow", parent), m_cache(cache) {

  setWindowTitle(cache.description());

  HtmlView *htmlView = new HtmlView(cache.longDescription());
  connect(this, SIGNAL(zoomInPressed()), htmlView, SLOT(zoomIn()));
  connect(this, SIGNAL(zoomOutPressed()), htmlView, SLOT(zoomOut()));

  addMenuEntry(tr("Open in browser"), this, SLOT(openCacheUrl()));

  setCentralWidget(htmlView);
}

DescriptionWindow::~DescriptionWindow() {
  qDebug() << __FUNCTION__;
}

void DescriptionWindow::openCacheUrl() {
  QDesktopServices::openUrl(m_cache.url());
}
