#include <QMainWindow>
#include <QDebug>
#include <QSettings>
#include <QAction>
#include <QPainter>
#include <QHBoxLayout>
#include <QFontInfo>
#include <QToolButton>

#include <QLabel>

#include "customwindow.h"

#ifdef Q_WS_MAEMO_5
#include <QtGui/QX11Info>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

static void grabZoomKeys(QWidget *window) {
  if(!window->winId()) return;
  
  unsigned long val = 1;
  Atom atom = XInternAtom(QX11Info::display(), "_HILDON_ZOOM_KEY_ATOM", False);
  if(!atom) return;
  
  XChangeProperty (QX11Info::display(), window->winId(), atom, 
		   XA_INTEGER, 32, PropModeReplace,
		   reinterpret_cast<unsigned char *>(&val),  1);
}
#endif

CustomWindow::CustomWindow(const QString &name, QWidget *parent) : 
  QMainWindow(parent), m_name(name), m_iconLoader(NULL), 
  m_layout(NULL), m_title(NULL)
#ifdef Q_OS_SYMBIAN
  ,iInterfaceSelector(NULL), iCoreTarget(NULL)
#endif
{
  qDebug() << __FUNCTION__;

#if !defined(Q_WS_MAEMO_5) && !defined(Q_OS_SYMBIAN)
  // restore window settings
  QSettings settings;
  settings.beginGroup(name);
  resize(settings.value("size", QSize(640, 480)).toSize());
  move(settings.value("pos", QPoint(200, 200)).toPoint());
  settings.endGroup();
#endif

#ifdef Q_WS_MAEMO_5
  setAttribute(Qt::WA_Maemo5StackedWindow);
  setAttribute(Qt::WA_Maemo5AutoOrientation, true);
  grabZoomKeys(this);
#endif

#if defined(Q_OS_SYMBIAN) || defined(Q_WS_SIMULATOR)
  // we use "custom window decorations" in fullscreen
  if(parent && !parent->isFullScreen()) {
    QAction *backAction = new QAction( tr("Back"), this );
    backAction->setSoftKeyRole( QAction::NegativeSoftKey );
    connect(backAction, SIGNAL(triggered()), this, SLOT(close()));
    addAction(backAction );
  }
#endif

  setAttribute(Qt::WA_DeleteOnClose);

#ifdef Q_OS_SYMBIAN
  // under Symbian only one entity can grab the media keys. We let the map get them
  if(!parent) {
    QT_TRAP_THROWING(iInterfaceSelector = CRemConInterfaceSelector::NewL());
    QT_TRAP_THROWING(iCoreTarget = CRemConCoreApiTarget::NewL(*iInterfaceSelector, *this));
    iInterfaceSelector->OpenTargetL();
  }
#endif

  /* symbian has a problem displaying maximized subwindows when the */
  /* parent window is fullscreen. Thus we force the child windows */
  /* to be fullscreen as well which in turn requires a means to return */
  /* frm them. We accomplish this by adding a custom widget on top */
  /* incl. a "back" button */

  /* under meegos tablet ux the windows are entirely unmanaged and */
  /* always need this */

#if defined(Q_OS_SYMBIAN) || defined(Q_WS_MEEGO)
  if(parent
#ifdef Q_OS_SYMBIAN
     && parent->isFullScreen()
#endif
     ) {
    m_iconLoader = new IconLoader(16);

    QWidget *vbox = new QWidget;
    m_layout = new QVBoxLayout;
    m_layout->setContentsMargins(0,0,0,0);
    m_layout->setSpacing(0);
    vbox->setLayout(m_layout);
    
    QWidget *hbox = new QWidget;
    QHBoxLayout *layout = new QHBoxLayout;
    layout->setContentsMargins(0,0,0,0);
    hbox->setLayout(layout);

    m_title = new QLabel();

    QFontInfo fontInfo(m_title->font());
    layout->addWidget(m_iconLoader->newWidget("cacheme", 
				  fontInfo.pixelSize()));

    layout->addWidget(m_title, 1);    

    QToolButton *button = new QToolButton;
    button->setAutoRaise( true );
    button->setContentsMargins(0,0,0,0);
 
    button->setIcon(QIcon(*m_iconLoader->load("button_back", 
					      fontInfo.pixelSize())));

    connect(button, SIGNAL(clicked()), this, SLOT(close()));

    layout->addWidget(button);    
    m_layout->addWidget(hbox);

    QMainWindow::setCentralWidget(vbox);
  }
#endif
}

void CustomWindow::setCentralWidget(QWidget *widget) {
  if(m_layout)
    m_layout->addWidget(widget);
  else
    QMainWindow::setCentralWidget(widget);    
}

void CustomWindow::setWindowTitle(const QString &title) {
  if(m_title) m_title->setText(title);
  QMainWindow::setWindowTitle(title);
}

CustomWindow::~CustomWindow() {
#if !defined(Q_WS_MAEMO_5) && !defined(Q_OS_SYMBIAN)
  QSettings settings;
  settings.beginGroup(m_name);
  settings.setValue("size", size());
  settings.setValue("pos", pos());
  settings.endGroup();
#endif

#ifdef Q_OS_SYMBIAN
  if(iInterfaceSelector) delete iInterfaceSelector;
#endif

  if(m_iconLoader) delete m_iconLoader;
}

#ifdef Q_OS_SYMBIAN
void CustomWindow::show() {
  // symbian has problems displaying maximized windows which are
  // children of fullscreen windows. We thus force all child
  // windows to be fullscreen as well. But then we need to add
  // some magic to be able to close such windows
  if(parentWidget() && parentWidget()->isFullScreen()) {
    qDebug() << __FUNCTION__ << "fullscreen";
    QWidget::showFullScreen();
  } else {
    qDebug() << __FUNCTION__ << "maximized";
    QWidget::showMaximized();
  }
}
#endif

void CustomWindow::keyPressEvent(QKeyEvent* event) {
  qDebug() << __FUNCTION__ << event->key();

  // check if device is in portrait mode
  bool portrait = size().height() > size().width();

  switch (event->key()) {
  case Qt::Key_F7:
    if(portrait) emit zoomOutPressed();
    else         emit zoomInPressed();
    event->accept();
    break;
    
  case Qt::Key_F8:
    if(portrait) emit zoomInPressed();
    else         emit zoomOutPressed();
    event->accept();
    break;
  }
  QWidget::keyPressEvent(event);
}

#ifdef Q_OS_SYMBIAN
// Callback when media keys are pressed
void CustomWindow::MrccatoCommand(TRemConCoreApiOperationId aOperationId,
				  TRemConCoreApiButtonAction aButtonAct) {

  // check if device is in portrait mode
  bool portrait = size().height() > size().width();

  //TRequestStatus status;
  switch( aOperationId ) {
  case ERemConCoreApiVolumeDown:
    if(portrait) emit zoomOutPressed();
    else         emit zoomInPressed();
    break;
  case ERemConCoreApiVolumeUp:
    if(portrait) emit zoomInPressed();
    else         emit zoomOutPressed();
    break;
  default:
    break;
  }
}
#endif

void CustomWindow::toggleFullscreen() {
  if(!isFullScreen())
    showFullScreen();
  else
#ifdef Q_OS_SYMBIAN
    showMaximized();
#else
    showNormal();
#endif
}
