#include <QDebug>
#include <QVBoxLayout>
#include <QGroupBox>
#include <QScrollArea>
#include <QDialogButtonBox>
#include <QGeoServiceProvider>
#include <QLabel>
#include <QSettings>

#include "settingsdialog.h"

void SettingsDialog::applyChanges() {
  qDebug() << __FUNCTION__;

  int type = m_typeCombo->itemData(m_typeCombo->currentIndex()).toInt();
  QString serviceStr = m_serviceCombo->currentText();

  QSettings settings;
  settings.beginGroup("Map");
  settings.setValue("Type", type);
  settings.setValue("Service", serviceStr);
  settings.endGroup();

  // type is handled immediately
  m_mapWidget->setMapType((QGraphicsGeoMap::MapType)type);
}

SettingsDialog::SettingsDialog(MapWidget *mapWidget, 
			       CacheProvider *cacheProvider, QWidget *parent) :
  QDialog(parent) {

  this->m_mapWidget = mapWidget;

  setWindowTitle(tr("Settings"));

  QVBoxLayout *mainLayout = new QVBoxLayout;
  mainLayout->setContentsMargins(0,0,0,0);

  QScrollArea *scrollArea = new QScrollArea(this);
  scrollArea->setWidgetResizable(true);
  scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

  QWidget *scrollWidget = new QWidget;
  QVBoxLayout *scrollvbox = new QVBoxLayout;
  scrollvbox->setContentsMargins(0,0,0,0);

  QGroupBox *groupBox = new QGroupBox(tr("Map"));
  QVBoxLayout *vbox = new QVBoxLayout;

  const QString mapTypeStr[] = {
    "No Map", tr("Street Map"), tr("Satellite Map Day"), 
    tr("Satellite Map Night"), tr("Terrain Map") };

  /* -------------- map type combo box --------------- */
  vbox->addWidget(new QLabel(tr("Map type") + ":", this));

  m_typeCombo = new QComboBox(this);
  QList<QGraphicsGeoMap::MapType> types = mapWidget->supportedMapTypes(); 

  // add entry for all map types
  for(int i = 0; i < types.size(); i++) {
    m_typeCombo->addItem(mapTypeStr[types[i]], types[i]);
    
    if(types[i] == mapWidget->mapType())
      m_typeCombo->setCurrentIndex(i);
  }

  vbox->addWidget(m_typeCombo);

  /* -------------- geo service combo box --------------- */
  vbox->addWidget(new QLabel(tr("Map service") + ":", this));

  m_serviceCombo = new QComboBox(this);
  QStringList list = QGeoServiceProvider::availableServiceProviders();
  for(int i=0;i<list.size();i++) {
    m_serviceCombo->addItem(list[i]);

    if(list[i] == mapWidget->managerName())
      m_serviceCombo->setCurrentIndex(i);
  }
 
  vbox->addWidget(m_serviceCombo);
  QLabel *label = new QLabel(tr("A change of the map service "
				"takes effect after restart."), this);
  label->setWordWrap(true);
  vbox->addWidget(label);

  groupBox->setLayout(vbox);
  scrollvbox->addWidget(groupBox);

  /* ------------------------ plugins ------------------------ */

  cacheProvider->pluginConfig(this, scrollvbox);

  scrollvbox->addStretch();
  scrollWidget->setLayout(scrollvbox);
  scrollArea->setWidget(scrollWidget);
  mainLayout->addWidget(scrollArea);

  QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok
				     | QDialogButtonBox::Cancel);

  connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
  connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

  mainLayout->addWidget(buttonBox);
  setLayout(mainLayout);

  connect(this, SIGNAL(accepted()), this, SLOT(applyChanges()));
}
