#ifndef GC_HTML_PARSER_H
#define GC_HTML_PARSER_H

#include <QString>
#include "cacheprovider.h"
#include "QSgmlTag.h"

class GcHtmlParser : public QObject {
  Q_OBJECT;
  
 public:
  GcHtmlParser();
  ~GcHtmlParser();

  bool decode(const QByteArray&, Cache &);
  QString error() const;
  void searchForItem(const QSgmlTag::QSgmlTaglist &, Cache &);
  void searchForLogs(const QSgmlTag::QSgmlTaglist &);
  QString searchForHintEncrypted(const QSgmlTag::QSgmlTaglist &);
  QString searchForItemContentText(const QSgmlTag::QSgmlTaglist &);
  QString searchForItemHeader(const QSgmlTag::QSgmlTaglist &);
  QString searchForItemHeaderH2(const QSgmlTag::QSgmlTaglist &);
  QString getText(const QSgmlTag::QSgmlTaglist &);
  QString getHtml(const QSgmlTag::QSgmlTaglist &);

  void dump(const QSgmlTag::QSgmlTaglist &, int = 0);
  void dump(const QSgmlTag *);

 private:

  QString m_error;
};

#endif // GC_HTML_PARSER_H
