######################################################################
# 
# cacheme.pro - project file for cacheme
#
######################################################################

TEMPLATE = app
include(../common.pri)

TARGET = ../$$APPNAME
DEPENDPATH += .
# QUAZIP = ./quazip-0.3/quazip
#INCLUDEPATH += . $$QUAZIP
QT += svg xml network
CONFIG += mobility debug
MOBILITY = location

maemo5 {
  QT += maemo5
  CONFIG += mobility12
}

# generic helpers
HEADERS += iconloader.h
SOURCES += iconloader.cpp 

# Input
HEADERS += customwindow.h mainwindow.h cache.h cacheprovider.h
SOURCES += customwindow.cpp mainwindow.cpp main.cpp cache.cpp cacheprovider.cpp

# cache detail view
HEADERS += swapbox.h cachewindow.h htmlview.h descriptionwindow.h
SOURCES += swapbox.cpp cachewindow.cpp htmlview.cpp descriptionwindow.cpp

# the map
HEADERS += mapwidget.h mapoverlay.h mapbutton.h mapbuttonmanager.h mapbubble.h settingsdialog.h
SOURCES += mapwidget.cpp mapoverlay.cpp mapbutton.cpp mapbuttonmanager.cpp mapbubble.cpp settingsdialog.cpp

# gps and navigation
HEADERS += locationprovider.h navigationwindow.h compass.h graphicscompass.h
SOURCES += locationprovider.cpp navigationwindow.cpp compass.cpp graphicscompass.cpp

# pocket query support
# HEADERS += gpx.h gpxparser.h gpxfileparser.h
# SOURCES += gpx.cpp gpxparser.cpp gpxfileparser.cpp

# disabled stuff
# HEADERS += cachelistpage.h cachemodel.h cachepage.h cachecell.h
# SOURCES += cachelistpage.cpp cachemodel.cpp cachepage.cpp cachecell.cpp

# Include local Quazip for ZIP handling
#HEADERS += $$QUAZIP/crypt.h $$QUAZIP/quachecksum32.h $$QUAZIP/quazipfileinfo.h $$QUAZIP/quazipnewinfo.h $$QUAZIP/zip.h $$QUAZIP/ioapi.h $$QUAZIP/quacrc32.h $$QUAZIP/quaadler32.h $$QUAZIP/quazipfile.h $$QUAZIP/quazip.h $$QUAZIP/unzip.h
#SOURCES += $$QUAZIP/ioapi.c $$QUAZIP/unzip.c $$QUAZIP/zip.c $$QUAZIP/quaadler32.cpp $$QUAZIP/quazip.cpp $$QUAZIP/quacrc32.cpp $$QUAZIP/quazipnewinfo.cpp $$QUAZIP/quazipfile.cpp

win32 {
  DEFINES += APPNAME=\\\"$$APPNAME\\\" VERSION=\\\"$$VERSION\\\"
  
  #MAKE INSTALL
}

unix {
  #VARIABLES
  isEmpty(PREFIX) {
    PREFIX = /usr
  }

  LIBS += -rdynamic
  BINDIR = $$PREFIX/bin
  DATADIR =$$PREFIX/share
  LIBDIR =$$PREFIX/lib

  DEFINES += DATADIR=\\\"$$DATADIR\\\" LIBDIR=\\\"$$LIBDIR\\\" APPNAME=\\\"$$APPNAME\\\" VERSION=\\\"$$VERSION\\\"

  #MAKE INSTALL

  INSTALLS += target desktop iconsvg icon64 icon48 icon26 icons translations

  target.path =$$BINDIR

  desktop.path = $$DATADIR/applications
  desktop.files = ../data/$${APPNAME}.desktop

  iconsvg.path = $$DATADIR/icons/hicolor/scalable/apps
  iconsvg.files = ../data/scalable/$${APPNAME}.svg

  icon64.path = $$DATADIR/icons/hicolor/64x64/apps
  icon64.files = ../data/64x64/$${APPNAME}.png

  icon48.path = $$DATADIR/icons/hicolor/48x48/apps
  icon48.files = ../data/48x48/$${APPNAME}.png

  icon26.path = $$DATADIR/icons/hicolor/26x26/apps
  icon26.files = ../data/26x26/$${APPNAME}.png

  icons.path = $$DATADIR/$${APPNAME}/icons
  icons.files = ../data/icons/*.svg

  translations.path = $$DATADIR/$${APPNAME}/lang
  translations.files = ../lang/*.qm

  maemo5 {
    # maemo5 expects everything in hildon and a 64x64 png in scalable ...
    desktop.path = $$DATADIR/applications/hildon
    iconsvg.path = $$DATADIR/icons/hicolor/scalable/hildon
    iconsvg.files = ../data/64x64/$${APPNAME}.png
    icon64.path = $$DATADIR/icons/hicolor/64x64/hildon
    icon48.path = $$DATADIR/icons/hicolor/48x48/hildon
    icon26.path = $$DATADIR/icons/hicolor/26x26/hildon
  }
}
