#include <QDebug>
#include "compass.h"

Compass::Compass(const Cache &cache, QWidget *parent) : 
  QGraphicsView(new QGraphicsScene(parent)),
  m_graphicsCompass(new GraphicsCompass(cache)),
  m_cache(cache) {
  
  qDebug() << __FUNCTION__;
  
  setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
  setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
  setVisible(true);
  setInteractive(true);
  
  scene()->addItem(m_graphicsCompass);

  connect(this, SIGNAL(positionUpdated(const QGeoPositionInfo &)),
     m_graphicsCompass, SLOT(setPosition(const QGeoPositionInfo &)));
}

Compass::~Compass() {
  qDebug() << __FUNCTION__;
}

void Compass::resizeEvent(QResizeEvent*) {
  setSceneRect(QRect(QPoint(0,0), contentsRect().size()));
  m_graphicsCompass->resize(contentsRect().size());
}

void Compass::setPosition(const QGeoPositionInfo &pos) {
  emit positionUpdated(pos);
}
