#ifndef GCLIVE_H
#define GCLIVE_H

#include <QObject>

#include "cache.h"
#include "cacheprovider.h"
#include "cacheproviderplugin.h"

class GcLive : public QObject, public CacheProviderPlugin {
 Q_OBJECT
 Q_INTERFACES(CacheProviderPlugin)
    
public:
  GcLive();
  ~GcLive();
  void setCacheProvider(CacheProvider*);

  QString name();
  bool busy();
  void processRequestOverview(const QGeoBoundingBox &);
  void processRequestInfo(const QString &);
  void processRequestDetail(const QString &);
  void createMenu(QMenu *);
  void login(const QString &, const QString &);

 public slots:
  void replyFinished(QNetworkReply*);

 signals:
  void replyOverview(const CacheList &);
  void replyInfo(const Cache &);
  void replyError(const QString &);    // any request can emit a error

 private slots:
  void confDialog();

 private:
  enum State { SentLoginGET, SentLoginPOST, RequestedUserToken, Idle };

  void requestUserToken();
  QString subString(QString &, const QString &, const QString &);
  bool decodeUserToken(const QByteArray&);
  void postJson(const QString &);
  void prepareLogin();
  void doLogin();
  void handleViewStateField(const QByteArray&);
  bool loginIsValid();
  void error(const QString &);
  int getCacheId(const QString &);
  QString getCacheGuid(const QString &);

  QNetworkAccessManager *m_manager;
  QString m_userToken;
  bool m_initialized;
  bool m_bigArea;
  CacheList m_cacheList;
  Cache m_cache;
  QString m_lastViewState;
  State m_state;

  QString m_loginName, m_loginPassword;

  CacheProvider *m_cacheProvider;
};

#endif // GCLIVE_H
