#include <QMainWindow>
#include <QSettings>

#include "customwindow.h"

#ifdef Q_WS_MAEMO_5
#include <QtGui/QX11Info>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

static void grabZoomKeys(QWidget *window) {
  if(!window->winId()) return;
  
  unsigned long val = 1;
  Atom atom = XInternAtom(QX11Info::display(), "_HILDON_ZOOM_KEY_ATOM", False);
  if(!atom) return;
  
  XChangeProperty (QX11Info::display(), window->winId(), atom, 
		   XA_INTEGER, 32, PropModeReplace,
		   reinterpret_cast<unsigned char *>(&val),  1);
}
#endif


CustomWindow::CustomWindow(const QString &name, QWidget *parent) : 
  QMainWindow(parent), m_name(name) {

  // restore window settings
  QSettings settings;
  settings.beginGroup(name);
  resize(settings.value("size", QSize(640, 480)).toSize());
  move(settings.value("pos", QPoint(200, 200)).toPoint());
  settings.endGroup();
  
#ifdef Q_WS_MAEMO_5
  setAttribute(Qt::WA_Maemo5StackedWindow);
  setAttribute(Qt::WA_Maemo5AutoOrientation, true);
  grabZoomKeys(this);
#endif

  setAttribute(Qt::WA_DeleteOnClose);
}

CustomWindow::~CustomWindow() {
  QSettings settings;
  settings.beginGroup(m_name);
  settings.setValue("size", size());
  settings.setValue("pos", pos());
  settings.endGroup();
}

void CustomWindow::keyPressEvent(QKeyEvent* event) {
  // check if device is in portrait mode
  bool portrait = size().height() > size().width();

  switch (event->key()) {
  case Qt::Key_F7:
    if(portrait) emit zoomOutPressed();
    else         emit zoomInPressed();
    event->accept();
    break;
    
  case Qt::Key_F8:
    if(portrait) emit zoomInPressed();
    else         emit zoomOutPressed();
    event->accept();
    break;
  }
  QWidget::keyPressEvent(event);
}
