#ifndef CACHEPROVIDER_H
#define CACHEPROVIDER_H

#include "cache.h"

#include <QQueue>
#include <QDir>

#include "cacheproviderplugin.h"

class CacheProvider  : public QObject {
  Q_OBJECT;

 public:
  CacheProvider();
  ~CacheProvider();
  void requestOverview(const QGeoBoundingBox &);
  void requestInfo(const QString &);
  void requestDetail(const QString &);
  void next();
  void done();
  void createMenu(QMenu *);
  void start();

  // functions redirected at current plugin
  QString name();
  bool busy();
  void processRequestOverview(const QGeoBoundingBox &);
  void processRequestInfo(const QString &);
  void processRequestDetail(const QString &);

  void emitReplyOverview(const CacheList &);
  void emitReplyInfo(const Cache &);
  void emitReplyDetail(const Cache &);
  void emitReplyError(const QString &);
  void emitSettingsChanged();
  void emitBusy(bool);

 signals:
  void replyOverview(const CacheList &);
  void replyInfo(const Cache &);
  void replyDetail(const Cache &);
  void replyError(const QString &);    // any request can emit a error
  void settingsChanged();
  void busy(bool);

 public:

  // a request entry is being kept in the request queue
  class RequestEntry {    
    
  public: 
    enum RequestType { Overview, Info, Detail };
    RequestEntry(const RequestType &, const QString &);
    RequestEntry(const RequestType &, const QGeoBoundingBox &);
    RequestType type();
    QGeoBoundingBox bbox();
    QString cache();
    void set(const QGeoBoundingBox &);
    void set(const QString &);

  private:
    RequestType m_type;
    QGeoBoundingBox m_bbox;
    QString m_cache;
  };

  class RequestQueue : public QQueue<RequestEntry *> {
  private:
    CacheProvider *m_cacheProvider;

  public:
    RequestQueue(CacheProvider *);
    bool add(const RequestEntry::RequestType &, const QString &);
    bool add(const RequestEntry::RequestType &, const QGeoBoundingBox &);
    RequestEntry::RequestType type();
    void done();
    void next();
    void restart();
  };
  
  RequestEntry::RequestType type();

 private:
  void loadPluginsInDir(QDir &);

  // queue of pending requests
  RequestQueue *m_pending;

  // list of available cache provider plugins
  QList <CacheProviderPlugin *> m_cacheProviderPluginList;
  CacheProviderPlugin *m_currentPlugin;
};

#endif // CACHEPROVIDER_H
