#ifndef MAP_WIDGET_H
#define MAP_WIDGET_H

#include <QGraphicsGeoMap>
#include <QGeoMappingManager>
#include <QGeoMapPixmapObject>
#include <QGeoMapCircleObject>
#include <QGeoMapGroupObject>
#include <QGeoPositionInfo>
#include <QTimer>

#include "cache.h"
#include "iconloader.h"

#include "mapoverlay.h"
#include "mapbubble.h"

QTM_USE_NAMESPACE

class MapWidget : public QGraphicsGeoMap {
  Q_OBJECT;

 public:
  MapWidget(QGeoMappingManager*);
  ~MapWidget();
  void updateCaches(const CacheList &);
  void updateZoomButtons();
  void hideBubble();
  QString managerName();

 signals:
  void mapChanged();
  void cacheClicked(const QString &);
  void showMessage(const QString &);
  
 public slots:
  void zoomIn();
  void zoomOut();
  void gpsFollow();
  void showBubble(const Cache &);
  void showDetails();
  
 private slots:
  void reloadTimerExpired();
  void reload();
  void zoomLevelChangedEvent(qreal);
  void centerChangedEvent(const QGeoCoordinate &);
  void positionUpdated(const QGeoPositionInfo &);

 protected:
  void mousePressEvent(QGraphicsSceneMouseEvent *);
  void mouseReleaseEvent(QGraphicsSceneMouseEvent *);
  void mouseMoveEvent(QGraphicsSceneMouseEvent *);
  void resizeEvent(QGraphicsSceneResizeEvent *);
  void showEvent(QShowEvent *);
  
 private:
  class MapCacheObject : public QGeoMapPixmapObject {
  public:
    MapCacheObject(IconLoader *, const Cache &);
    bool contains( const QGeoCoordinate &) const;
  };

  // this should actually be much lower on non-touch devices
  static const int DRAG_FUZZ = 30;
  
  int m_iconSize;
  QPointF m_downPos;
  IconLoader *m_iconLoader;
  MapOverlay *m_mapOverlay;
  QTimer *m_timer;
  MapBubble *m_bubble;
  QGeoBoundingBox m_currentViewport;
  bool m_dragging;
  bool m_posIsValid;
  bool m_gpsLocked;
  int m_precisionAlpha;

  QGeoMapPixmapObject *m_gpsMarker;
  QGeoMapCircleObject *m_gpsPrecision;
  QGeoMapGroupObject *m_cacheGroup;
  QGeoMappingManager *m_manager;
};

#endif // MAP_WIDGET_H
