#include <QDebug>
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QGeoServiceProvider>
#include <QLabel>
#include <QSettings>

#include "mapdialog.h"

void MapDialog::applyChanges() {
  qDebug() << __FUNCTION__;

  int type = m_typeCombo->itemData(m_typeCombo->currentIndex()).toInt();
  QString serviceStr = m_serviceCombo->currentText();

  QSettings settings;
  settings.beginGroup("Map");
  settings.setValue("Type", type);
  settings.setValue("Service", serviceStr);
  settings.endGroup();

  // type is handled immediately
  m_mapWidget->setMapType((QGraphicsGeoMap::MapType)type);
}

MapDialog::MapDialog(MapWidget *mapWidget, QWidget *parent) :
  QDialog(parent) {

  this->m_mapWidget = mapWidget;

  setWindowTitle(tr("Map settings"));

  const QString mapTypeStr[] = {
    "No Map", tr("Street Map"), tr("Satellite Map Day"), 
    tr("Satellite Map Night"), tr("Terrain Map") };

  QVBoxLayout *mainLayout = new QVBoxLayout;

  /* -------------- map type combo box --------------- */
  mainLayout->addWidget(new QLabel(tr("Map type") + ":", this));

  m_typeCombo = new QComboBox(this);
  QList<QGraphicsGeoMap::MapType> types = mapWidget->supportedMapTypes(); 

  // add entry for all map types
  for(int i = 0; i < types.size(); i++) {
    m_typeCombo->addItem(mapTypeStr[types[i]], types[i]);
    
    if(types[i] == mapWidget->mapType())
      m_typeCombo->setCurrentIndex(i);
  }

  mainLayout->addWidget(m_typeCombo);

  /* -------------- geo service combo box --------------- */
  mainLayout->addWidget(new QLabel(tr("Map service") + ":", this));

  m_serviceCombo = new QComboBox(this);
  QStringList list = QGeoServiceProvider::availableServiceProviders();
  for(int i=0;i<list.size();i++) {
    m_serviceCombo->addItem(list[i]);

    if(list[i] == mapWidget->managerName())
      m_serviceCombo->setCurrentIndex(i);
  }
 
  mainLayout->addWidget(m_serviceCombo);
  QLabel *label = new QLabel(tr("A change of the map service "
				"takes effect after restart."), this);
  label->setWordWrap(true);
  mainLayout->addWidget(label);

  mainLayout->addStretch(1);

  QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok
				     | QDialogButtonBox::Cancel);

  connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
  connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

  mainLayout->addWidget(buttonBox);
  setLayout(mainLayout);

  connect(this, SIGNAL(accepted()), this, SLOT(applyChanges()));
}
