/****************************************************************************
**
** Copyright (C) 2011 Cloudmade 
** All rights reserved.
** Contact: Cloudmade (qtmobility@cloudmade.com)
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** If you have questions regarding the use of this file, please contact
** Cloudmade at qtmobility@cloudmade.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qgeomappingmanagerengine_cm.h"
#include "qgeomapreply_cm.h"
#include "debug_cm.h"

#include <qgeotiledmaprequest.h>

#include <QNetworkAccessManager>
#include <QNetworkDiskCache>
#include <QNetworkProxy>
#include <QSize>
#include <QDir>
#include <QDateTime>
#include <QApplication>
#include <QFileInfo>


QGeoMappingManagerEngineCm::QGeoMappingManagerEngineCm(const QMap<QString, QVariant> &parameters, QGeoServiceProvider::Error *error, QString *errorString)
        : QGeoTiledMappingManagerEngine(parameters),
        m_parameters(parameters),
	m_host("b.tile.cloudmade.com"),
	m_token(QGeoServiceProviderFactoryCm::defaultToken)
{
    Q_UNUSED(error)
    Q_UNUSED(errorString)

    setTileSize(QSize(256,256));
    setMinimumZoomLevel(0.0);
    setMaximumZoomLevel(18.0);

	//SL_MAP_TYPE
	QList<QGraphicsGeoMap::MapType> types;
    types << QGraphicsGeoMap::StreetMap;
	types << QGraphicsGeoMap::SatelliteMapDay;
	types << QGraphicsGeoMap::SatelliteMapNight;
	types << QGraphicsGeoMap::TerrainMap;
	setSupportedMapTypes(types);

    m_nam = new QNetworkAccessManager(this);
    m_cache = new QNetworkDiskCache(this);

    QDir dir = QDir::temp();
    dir.mkdir("maptiles-cm");
    dir.cd("maptiles-cm");

    m_cache->setCacheDirectory(dir.path());

    QList<QString> keys = m_parameters.keys();

    if (keys.contains("mapping.proxy")) {
        QString proxy = m_parameters.value("mapping.proxy").toString();
        if (!proxy.isEmpty())
            m_nam->setProxy(QNetworkProxy(QNetworkProxy::HttpProxy, proxy, 8080));
    }

    if (keys.contains("mapping.host")) {
        QString host = m_parameters.value("mapping.host").toString();
        if (!host.isEmpty())
            m_host = host;
    }

    if (keys.contains("mapping.cache.directory")) {
        QString cacheDir = m_parameters.value("mapping.cache.directory").toString();
        if (!cacheDir.isEmpty())
            m_cache->setCacheDirectory(cacheDir);
    }

    if (keys.contains("mapping.cache.size")) {
        bool ok = false;
        qint64 cacheSize = m_parameters.value("mapping.cache.size").toString().toLongLong(&ok);
        if (ok)
            m_cache->setMaximumCacheSize(cacheSize);
    }

    m_nam->setCache(m_cache);
}

QGeoMappingManagerEngineCm::~QGeoMappingManagerEngineCm() {}

QGeoTiledMapReply* QGeoMappingManagerEngineCm::getTileImage(const QGeoTiledMapRequest &request)
{
    QString rawRequest = getRequestString(request);

	DBG_CM(TILES_M, INFO_L, "tileURL:" << rawRequest );

    QNetworkRequest netRequest = QNetworkRequest(QUrl(rawRequest));
    netRequest.setAttribute(QNetworkRequest::CacheLoadControlAttribute, QNetworkRequest::PreferCache);
    QString ua = QFileInfo(QApplication::applicationFilePath()).fileName();
    ua.remove(QChar('"'), Qt::CaseInsensitive);
    ua += " (Qt";
    ua += qVersion();
    ua += " QtMobility 1.1 ) cm GeoSearchManager";
    netRequest.setRawHeader("User-Agent", ua.toAscii());
    m_cache->metaData(netRequest.url()).setLastModified(QDateTime::currentDateTime());

    QNetworkReply* netReply = m_nam->get(netRequest);

    QGeoTiledMapReply* mapReply = new QGeoMapReplyCm(netReply, request, this);

    return mapReply;
}

QString QGeoMappingManagerEngineCm::getRequestString(const QGeoTiledMapRequest &request) const
{
    QString requestString = "http://";
    QString tileStyleId;
    QString tileDimension = "256";

	switch (request.mapType()) {
	case QGraphicsGeoMap::StreetMap:  
		tileStyleId = QString("1");  
		break;  
	case QGraphicsGeoMap::SatelliteMapDay:  
		tileStyleId = QString("1155");  
		break;  
	case QGraphicsGeoMap::SatelliteMapNight:  
		tileStyleId = QString("999");  
		break;  
	case QGraphicsGeoMap::TerrainMap:  
		tileStyleId = QString("15085");  
		break;  
	default:  
		tileStyleId = QString("1");  
		break;
	}  

    requestString += m_host;
    if (!m_token.isNull())
	requestString += '/' + m_token;
    requestString += '/';
    requestString += tileStyleId;
    requestString += '/';
    requestString += tileDimension;
    requestString += '/';
    requestString += QString::number(request.zoomLevel());
    requestString += '/';
    requestString += QString::number(request.column());
    requestString += '/';
    requestString += QString::number(request.row());
    requestString += '.';
    requestString += "png";

    return requestString;
}

