/*
 * butaca-service.c
 *
 * This file is part of butaca
 * Copyright (C) 2010 Simón Pena <spenap@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */

#include <dbus/dbus-glib.h>

#include "btc-minfo-provider-service.h"

int
main (int argc, char **argv)
{
        BtcMInfoProviderService *service = NULL;
        DBusGConnection *connection = NULL;
        GError *error = NULL;
        GMainLoop *loop = NULL;

        g_type_init ();
        if (!g_thread_supported ())
                g_thread_init (NULL);

        connection = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
        if (connection == NULL) {
                g_warning ("Unable to connect to dbus: %s", error->message);
                g_error_free (error);
                return -1;
        }

        loop = g_main_loop_new (NULL, FALSE);
        service = btc_minfo_provider_service_new (connection, loop);

        g_main_loop_run (loop);

        g_object_unref (service);
        g_main_loop_unref (loop);
        dbus_g_connection_unref (connection);
        if (error != NULL)
                g_error_free (error);

        return 0;
}

