/*
 * btc-tmdb-movie.h
 *
 * This file is part of butaca
 * Copyright (C) 2010 Simón Pena <spenap@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */

#ifndef _BTC_TMDB_MOVIE
#define _BTC_TMDB_MOVIE

#include <glib-object.h>

G_BEGIN_DECLS

#define BTC_TYPE_TMDB_MOVIE btc_tmdb_movie_get_type()
#define BTC_TMDB_MOVIE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), BTC_TYPE_TMDB_MOVIE, BtcTmdbMovie))
#define BTC_TMDB_MOVIE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), BTC_TYPE_TMDB_MOVIE, BtcTmdbMovieClass))
#define BTC_IS_TMDB_MOVIE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BTC_TYPE_TMDB_MOVIE))
#define BTC_IS_TMDB_MOVIE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), BTC_TYPE_TMDB_MOVIE))
#define BTC_TMDB_MOVIE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), BTC_TYPE_TMDB_MOVIE, BtcTmdbMovieClass))

typedef struct _BtcTmdbMoviePrivate BtcTmdbMoviePrivate;

typedef struct {
        GObject parent;

        /* <private> */
        BtcTmdbMoviePrivate *priv;
} BtcTmdbMovie;

typedef struct {
        GObjectClass parent_class;
} BtcTmdbMovieClass;

GType btc_tmdb_movie_get_type (void);
BtcTmdbMovie* btc_tmdb_movie_new (void);

gboolean
btc_tmdb_movie_set_alt_name (BtcTmdbMovie *self, const gchar *alt_name);

const gchar*
btc_tmdb_movie_get_alt_name (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_certification (BtcTmdbMovie *self, const gchar *certification);

const gchar*
btc_tmdb_movie_get_certification (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_id (BtcTmdbMovie *self, const gchar *id);

const gchar*
btc_tmdb_movie_get_id (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_images (BtcTmdbMovie *self, GList *images);

GList*
btc_tmdb_movie_get_images (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_imdb_id (BtcTmdbMovie *self, const gchar *imdb_id);

const gchar*
btc_tmdb_movie_get_imdb_id (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_language (BtcTmdbMovie *self, const gchar *language);

const gchar*
btc_tmdb_movie_get_language (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_last_modified (BtcTmdbMovie *self,
                                  const gchar *last_modified);

const gchar*
btc_tmdb_movie_get_last_modified (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_name (BtcTmdbMovie *self, const gchar *names);

const gchar*
btc_tmdb_movie_get_name (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_overview (BtcTmdbMovie *self, const gchar *overview);

const gchar*
btc_tmdb_movie_get_overview (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_popularity (BtcTmdbMovie *self, const gchar *popularity);

const gchar*
btc_tmdb_movie_get_popularity (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_rating (BtcTmdbMovie *self, const gchar *rating);

const gchar*
btc_tmdb_movie_get_rating (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_released (BtcTmdbMovie *self, const gchar *released);

const gchar*
btc_tmdb_movie_get_released (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_score (BtcTmdbMovie *self, const gchar *score);

const gchar*
btc_tmdb_movie_get_score (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_translated (BtcTmdbMovie *self, const gchar *translated);

const gchar*
btc_tmdb_movie_get_translated (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_type (BtcTmdbMovie *self, const gchar *type);

const gchar*
btc_tmdb_movie_get_source_type (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_url (BtcTmdbMovie *self, const gchar *url);

const gchar*
btc_tmdb_movie_get_url (BtcTmdbMovie *self);

void
btc_tmdb_movie_print (BtcTmdbMovie *self);

const gchar*
btc_tmdb_movie_get_adult (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_adult (BtcTmdbMovie *self, const gchar *adult);

const gchar*
btc_tmdb_movie_get_original_name(BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_original_name(BtcTmdbMovie *self, const gchar *original_name);

const gchar*
btc_tmdb_movie_get_votes (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_votes (BtcTmdbMovie *self, const gchar *votes);

const gchar*
btc_tmdb_movie_get_version (BtcTmdbMovie *self);

gboolean
btc_tmdb_movie_set_version (BtcTmdbMovie *self, const gchar *version);

G_END_DECLS

#endif /* _BTC_TMDB_MOVIE */
