/*
 * btc-watc-movie.h
 *
 * This file is part of butaca
 * Copyright (C) 2010 Simón Pena <spenap@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */

#ifndef _BTC_WATC_MOVIE
#define _BTC_WATC_MOVIE

#include <glib-object.h>

G_BEGIN_DECLS

enum {
        BTC_STINGERS_UNKNOWN,
        BTC_STINGERS_YES,
        BTC_STINGERS_NO,
        BTC_STINGERS_LAST
};

#define BTC_TYPE_WATC_MOVIE btc_watc_movie_get_type()
#define BTC_WATC_MOVIE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), BTC_TYPE_WATC_MOVIE, BtcWatcMovie))
#define BTC_WATC_MOVIE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), BTC_TYPE_WATC_MOVIE, BtcWatcMovieClass))
#define BTC_IS_WATC_MOVIE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BTC_TYPE_WATC_MOVIE))
#define BTC_IS_WATC_MOVIE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), BTC_TYPE_WATC_MOVIE))
#define BTC_WATC_MOVIE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), BTC_TYPE_WATC_MOVIE, BtcWatcMovieClass))

typedef struct _BtcWatcMoviePrivate BtcWatcMoviePrivate;

typedef struct {
        GObject parent;

        /* <private> */
        BtcWatcMoviePrivate *priv;
} BtcWatcMovie;

typedef struct {
        GObjectClass parent_class;
} BtcWatcMovieClass;

GType btc_watc_movie_get_type (void);

BtcWatcMovie* btc_watc_movie_new (const gchar *raw_name);

gboolean
btc_watc_movie_set_name (BtcWatcMovie *self, const gchar *name);

const gchar*
btc_watc_movie_get_name (BtcWatcMovie *self);

gboolean
btc_watc_movie_set_stingers (BtcWatcMovie *self, int stingers);

gint
btc_watc_movie_get_stingers (BtcWatcMovie *self);

gboolean
btc_watc_movie_set_year (BtcWatcMovie *self, const gchar *year);

const gchar*
btc_watc_movie_get_year (BtcWatcMovie *self);

void
btc_watc_movie_print (BtcWatcMovie *self);

G_END_DECLS

#endif /* _BTC_WATC_MOVIE */
