/*
 * btc-tmdb-movie-service.h
 *
 * This file is part of butaca
 * Copyright (C) 2010 Simón Pena <spenap@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */

#ifndef _BTC_TMDB_MOVIE_SERVICE
#define _BTC_TMDB_MOVIE_SERVICE

#include <glib-object.h>
#include "btc-tmdb-movie.h"

G_BEGIN_DECLS

#define BTC_TYPE_TMDB_MOVIE_SERVICE btc_tmdb_movie_service_get_type()
#define BTC_TMDB_MOVIE_SERVICE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), BTC_TYPE_TMDB_MOVIE_SERVICE, BtcTmdbMovieService))
#define BTC_TMDB_MOVIE_SERVICE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), BTC_TYPE_TMDB_MOVIE_SERVICE, BtcTmdbMovieServiceClass))
#define BTC_IS_TMDB_MOVIE_SERVICE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BTC_TYPE_TMDB_MOVIE_SERVICE))
#define BTC_IS_TMDB_MOVIE_SERVICE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), BTC_TYPE_TMDB_MOVIE_SERVICE))
#define BTC_TMDB_MOVIE_SERVICE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), BTC_TYPE_TMDB_MOVIE_SERVICE, BtcTmdbMovieServiceClass))

typedef struct _BtcTmdbMovieServicePrivate BtcTmdbMovieServicePrivate;

typedef struct {
        GObject parent;

        /* <private> */
        BtcTmdbMovieServicePrivate *priv;
} BtcTmdbMovieService;

typedef struct {
        GObjectClass parent_class;
} BtcTmdbMovieServiceClass;

GType btc_tmdb_movie_service_get_type (void);
BtcTmdbMovieService* btc_tmdb_movie_service_new (DBusGConnection *connection,
                BtcTmdbMovie *movie, const gchar *suffix);

G_END_DECLS

#endif /* _BTC_TMDB_MOVIE_SERVICE */
