#!/bin/sh
set -e

INSTALLDIR="/opt/busybox-power"
EXECPWR="$INSTALLDIR/busybox.power"

MECHANISM="$1" # ariadne or opensh
MODE="$2" # inst (install) or uninst (uninstall)

TMPSCRIPT=`$EXECPWR mktemp`
TMPHASHBAK=`$EXECPWR mktemp`

case $MODE in
  inst)
    INSTBINARY="$INSTALLDIR/busybox.power"
    ORIGBINARY="$INSTALLDIR/busybox.original"
    MSG="\nNow going to replace /bin/busybox\nwith our (busybox-power) version.\n"
  ;;
  uninst)
    INSTBINARY="$INSTALLDIR/busybox.original"
    ORIGBINARY="$INSTALLDIR/busybox.power"
    MSG="\nNow going to replace /bin/busybox\nwith the original (stock) version.\n"
  ;;
  *)
    exit 2
  ;;
esac

$EXECPWR cat > $TMPSCRIPT << EOF
#!/bin/sh
ERROR() {
  $EXECPWR touch /tmp/busybox-power-error
  $EXECPWR chmod 666 /tmp/busybox-power-error # for cleanup by non-root script
  if test "\$1" -eq "1"; then
    # Potentially hazardous errors
    echo -e "\nWarning: an error has occured! Rolling back..."
    echo " -> restoring /bin/busybox"
    echo "    from $ORIGBINARY"
    $EXECPWR cp -f $ORIGBINARY /bin/busybox
    echo " -> restoring /var/lib/aegis/refhashlist"
    echo "    from $TMPHASHBAK"
    $EXECPWR cp -a $TMPHASHBAK /var/lib/aegis/refhashlist
    echo "End of roll-back."
    echo "This script will terminate automatically in 30 seconds"
    $EXECPWR sleep 30
  fi
  exit 1
}
$EXECPWR cp -a /var/lib/aegis/refhashlist $TMPHASHBAK || ERROR 0
aegisctl -s > /dev/null || ERROR 0
$EXECPWR cp -f $INSTBINARY /bin/busybox || ERROR 1
$EXECPWR sed -i "s/$ORIGBINARY_SHA1/$INSTBINARY_SHA1/" /var/lib/aegis/refhashlist || ERROR 1
accli -c tcb-sign -F /var/lib/aegis/refhashlist < /var/lib/aegis/refhashlist || ERROR 1
$EXECPWR rm $TMPHASHBAK
EOF

$EXECPWR chmod +x $TMPSCRIPT

case $MECHANISM in
  ariadne)
    # ariadne requires user interaction, use meego-terminal
    TMPWRAPPER=`$EXECPWR mktemp`

    $EXECPWR cat > $TMPWRAPPER << EOF
#!/bin/sh
echo -e "$MSG";
while true; do
  ariadne -u root -- $TMPSCRIPT
  if test "\$?" -eq "1" -a ! -e /tmp/busybox-power-error; then
    read -p "Retry? y/n " -n 1 -r
    if ! test "\$REPLY" = "y" -o "\$REPLY" = "Y"; then break; fi
    echo -e "\n"
  else
    break
  fi
done
EOF

    $EXECPWR chmod +x $TMPWRAPPER
    meego-terminal -e $TMPWRAPPER
    $EXECPWR rm $TMPWRAPPER
  ;;
  opensh)
    opensh -c $TMPSCRIPT
  ;;
  *)
    exit 2
  ;;
esac

$EXECPWR rm $TMPSCRIPT

if test -e /tmp/busybox-power-error; then
  $EXECPWR rm /tmp/busybox-power-error; exit 1; fi

