#include <QSettings>

#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog),
    settings(qApp->organizationName(), qApp->applicationName())
{
    QString league;
    int     index;

    ui->setupUi(this);

    league = settings.value("League", "1. Bundesliga").toString();
    if ((index = ui->cbLeague->findText(league)) != -1) {
        ui->cbLeague->setCurrentIndex(index);
    } else {
        ui->cbLeague->setCurrentIndex(0);
    }
    ui->cbPlaySound->setChecked(settings.value("Sounds", false).toBool());

    connect(ui->buttonBox, SIGNAL(accepted()), this, SLOT(onDlgAccepted()));
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::onDlgAccepted()
{
    settings.setValue("League", ui->cbLeague->currentText());
    settings.setValue("Sounds", ui->cbPlaySound->isChecked());
    this->accept();
}
